/*
 * Decompiled with CFR 0.152.
 */
package niv.flowstone.config;

import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import niv.flowstone.config.ConfigurationLoader;

public final class Configuration {
    public static final Event<Runnable> LOADED = EventFactory.createArrayBacked(Runnable.class, runnables -> () -> Stream.of(runnables).forEach(Runnable::run));
    private boolean allowDeepslateGenerators = true;
    private boolean allowWorldlyGenerators = true;
    private boolean allowCustomGenerators = false;
    private boolean enableBasaltGeneration = false;
    private boolean enableNetherrackGeneration = true;
    private boolean enableEndStoneGeneration = true;
    private Boolean debugMode = null;

    Configuration() {
    }

    private boolean getDebugMode() {
        return this.debugMode != null && this.debugMode != false;
    }

    private static final Configuration getInstance() {
        return ConfigurationLoader.getConfiguration();
    }

    public static final void init() {
        Configuration.getInstance();
    }

    public static final boolean allowDeepslateGenerators() {
        return Configuration.getInstance().allowDeepslateGenerators;
    }

    public static final boolean allowWorldlyGenerators() {
        return Configuration.getInstance().allowWorldlyGenerators;
    }

    public static final boolean allowCustomGenerators() {
        return Configuration.getInstance().allowCustomGenerators;
    }

    public static final boolean enableBasaltGeneration() {
        return Configuration.getInstance().enableBasaltGeneration;
    }

    public static final boolean enableNetherrackGeneration() {
        return Configuration.getInstance().enableNetherrackGeneration;
    }

    public static final boolean enableEndStoneGeneration() {
        return Configuration.getInstance().enableEndStoneGeneration;
    }

    public static final boolean debugMode() {
        return Configuration.getInstance().getDebugMode();
    }
}

