/*
 * Decompiled with CFR 0.152.
 */
package niv.flowstone.config;

import com.google.common.base.Suppliers;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import niv.flowstone.Flowstone;
import niv.flowstone.config.Configuration;

public final class ConfigurationLoader {
    private static final long DELAY = 5000L;
    private static final Gson gson = new GsonBuilder().setLenient().setPrettyPrinting().create();
    private static final Supplier<File> configurationFile = Suppliers.memoize(() -> FabricLoader.getInstance().getGameDir().resolve("config").resolve("flowstone.json").toFile());
    private static Configuration configuration = new Configuration();
    private static long timestamp = 0L;
    private static long lastModified = 0L;
    private static boolean fireOnReturn = true;

    private ConfigurationLoader() {
    }

    static final Configuration getConfiguration() {
        ConfigurationLoader.synchConfiguration();
        if (fireOnReturn) {
            ((Runnable)Configuration.LOADED.invoker()).run();
            fireOnReturn = false;
        }
        return configuration;
    }

    private static final synchronized void synchConfiguration() {
        long now = System.currentTimeMillis();
        if (timestamp + 5000L < now) {
            File file = configurationFile.get();
            try {
                if (ConfigurationLoader.create(file) || ConfigurationLoader.read(file)) {
                    ConfigurationLoader.write(file);
                }
            }
            catch (IllegalStateException ex) {
                Flowstone.LOGGER.warn(ex.getMessage(), (Throwable)ex);
            }
            timestamp = now;
        }
    }

    private static final boolean create(File file) {
        try {
            return !file.isFile() && (file.getParentFile().isDirectory() || file.getParentFile().mkdirs()) && file.createNewFile();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to create configuration file", ex);
        }
    }

    private static final boolean read(File file) {
        boolean bl;
        long newLastModified = file.lastModified();
        if (newLastModified <= lastModified) {
            return false;
        }
        lastModified = newLastModified;
        FileReader reader = new FileReader(file);
        try {
            Configuration result = (Configuration)gson.fromJson((Reader)reader, Configuration.class);
            if (result != null) {
                configuration = result;
                fireOnReturn = true;
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonIOException | JsonSyntaxException | IOException ex) {
                throw new IllegalStateException("Failed to read configuration file", ex);
            }
        }
        reader.close();
        return bl;
    }

    private static final void write(File file) {
        try (FileWriter writer = new FileWriter(file);){
            gson.toJson((Object)configuration, (Appendable)writer);
            lastModified = file.lastModified();
        }
        catch (JsonIOException | IOException ex) {
            throw new IllegalStateException("Failed to write configuration file", ex);
        }
    }
}

