/*
 * Decompiled with CFR 0.152.
 */
package niv.flowstone.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import it.unimi.dsi.fastutil.ints.Int2DoubleFunction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBlockTags;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2975;
import net.minecraft.class_3124;
import net.minecraft.class_3218;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_5868;
import net.minecraft.class_6122;
import net.minecraft.class_6124;
import net.minecraft.class_6342;
import net.minecraft.class_6793;
import net.minecraft.class_6795;
import net.minecraft.class_6796;
import net.minecraft.class_6797;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import niv.flowstone.Replacers;
import niv.flowstone.api.Generator;
import niv.flowstone.api.Replacer;
import niv.flowstone.config.Configuration;

public class WorldlyGenerator
implements Generator {
    private static final Table<class_2248, class_1959, Set<Generator>> biomeCache = HashBasedTable.create();
    private static final Table<class_2248, class_6796, Set<Generator>> featureCache = HashBasedTable.create();
    private static final Map<class_6796, Optional<BaseGenerator>> baseGeneratorCache = new HashMap<class_6796, Optional<BaseGenerator>>();
    private final class_2680 state;
    private final int blockCount;
    private final int maxBlockCount;
    private final Int2DoubleFunction function;

    private WorldlyGenerator(class_2680 state, int blockCount, int maxBlockCount, Int2DoubleFunction function) {
        this.state = state;
        this.blockCount = blockCount;
        this.maxBlockCount = maxBlockCount;
        this.function = function;
    }

    @Override
    public Optional<class_2680> apply(class_1936 level, class_2338 pos) {
        return Optional.of(this.state).filter(x -> this.test(level.method_8409(), pos.method_10264()));
    }

    private boolean test(class_5819 random, int y) {
        return Configuration.debugMode() || (double)random.method_43048(this.maxBlockCount) < (double)this.blockCount * this.function.applyAsDouble(y);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("state", (Object)this.state).add("blockCount", this.blockCount).add("maxBlockCount", this.maxBlockCount).add("function", (Object)this.function).toString();
    }

    private static final class_2680 applyAll(class_1936 accessor, class_2338 pos, class_2680 state) {
        class_1959 biome = (class_1959)accessor.method_23753(pos).comp_349();
        Set<Object> result = (Set)biomeCache.get((Object)state.method_26204(), (Object)biome);
        if (result == null) {
            if (accessor instanceof class_3218) {
                class_3218 level = (class_3218)accessor;
                result = biome.method_30970().method_30983().stream().flatMap(class_6885::method_40239).map(class_6880::comp_349).flatMap(value -> {
                    Set<Generator> generators = (Set<Generator>)featureCache.get((Object)state.method_26204(), value);
                    if (generators == null) {
                        generators = WorldlyGenerator.loadGenerators(level, value, state);
                        featureCache.put((Object)state.method_26204(), value, generators);
                    }
                    return generators.stream();
                }).collect(Collectors.toSet());
            } else {
                result = Set.of();
            }
            biomeCache.put((Object)state.method_26204(), (Object)biome, result);
        }
        return Generator.applyAll((Collection<? extends Generator>)result, accessor, pos).orElse(state);
    }

    private static final Set<Generator> loadGenerators(class_3218 level, class_6796 feature, class_2680 state) {
        Optional base = baseGeneratorCache.computeIfAbsent(feature, key -> WorldlyGenerator.loadBaseGenerator(level, feature));
        if (base.isEmpty()) {
            return Set.of();
        }
        Optional<class_3124> config = feature.method_39643().map(class_2975::comp_333).filter(class_3124.class::isInstance).findFirst().map(class_3124.class::cast);
        if (config.isEmpty()) {
            return Set.of();
        }
        return config.stream().flatMap(value -> value.field_29063.stream()).filter(value -> value.field_29068.method_16768(state, class_5819.method_43049((long)0L))).map(value -> value.field_29069).distinct().filter(value -> value.method_26164(ConventionalBlockTags.ORES)).map(value -> new WorldlyGenerator((class_2680)value, ((BaseGenerator)base.get()).blockCount() * Math.max(1, ((class_3124)config.get()).field_13723), ((BaseGenerator)base.get()).maxBlockCount(), ((BaseGenerator)base.get()).function())).collect(Collectors.toSet());
    }

    private static final Optional<BaseGenerator> loadBaseGenerator(class_3218 level, class_6796 feature) {
        BaseGeneratorBuilder builder = new BaseGeneratorBuilder();
        class_5868 context = new class_5868(level.method_14178().method_12129(), (class_5539)level);
        for (class_6797 element : feature.comp_335()) {
            if (element instanceof class_6793) {
                class_6793 modifier = (class_6793)element;
                WorldlyGenerator.processCount(builder, modifier);
                continue;
            }
            if (!(element instanceof class_6795)) continue;
            class_6795 modifier = (class_6795)element;
            WorldlyGenerator.processHeightRange(builder, context, modifier);
        }
        return builder.tryBuild();
    }

    private static final void processCount(BaseGeneratorBuilder builder, class_6793 modifier) {
        builder.blockCountMultiply(modifier.field_35719.method_35011());
    }

    private static final void processHeightRange(BaseGeneratorBuilder builder, class_5868 context, class_6795 modifier) {
        class_6122 class_61222 = modifier.field_35726;
        if (class_61222 instanceof class_6124) {
            class_6124 uniform = (class_6124)class_61222;
            int maxY = uniform.field_31547.method_33844(context);
            int minY = uniform.field_31546.method_33844(context);
            builder.maxBlockCount(Math.max(0, maxY - minY) * 256).function(new UniformFunction(minY, maxY));
        } else {
            class_6122 maxY = modifier.field_35726;
            if (maxY instanceof class_6342) {
                int minY;
                class_6342 trapezoid = (class_6342)maxY;
                int maxY2 = trapezoid.field_33525.method_33844(context);
                int l = Math.max(0, maxY2 - (minY = trapezoid.field_33524.method_33844(context)) - trapezoid.field_33526) / 2;
                if (l == 0) {
                    builder.maxBlockCount(Math.max(0, maxY2 - minY) * 256).function(new UniformFunction(minY, maxY2));
                } else {
                    int maxL = maxY2 - l;
                    int minL = minY + l;
                    builder.maxBlockCount(Math.max(0, maxY2 - minY + trapezoid.field_33526) * 128).function(new TrapezoidFunction(minY, minL, l, maxL, maxY2));
                }
            }
        }
    }

    public static final ServerWorldEvents.Load getCacheInvalidator() {
        return (server, level) -> {
            biomeCache.clear();
            featureCache.clear();
            baseGeneratorCache.clear();
        };
    }

    public static final Replacer getReplacer() {
        return Replacers.defaultedMultiReplacer(Replacers.allowedBlocksNullableReplacer(class_2246.field_10340, class_2246.field_28888, class_2246.field_10515), WorldlyGenerator::applyAll);
    }

    private static final class BaseGeneratorBuilder {
        private Integer blockCount = 1;
        private Integer maxBlockCount = null;
        private Int2DoubleFunction function = null;

        private BaseGeneratorBuilder() {
        }

        public BaseGeneratorBuilder blockCountMultiply(int value) {
            this.blockCount = this.blockCount == null ? Integer.valueOf(value) : Integer.valueOf(this.blockCount * value);
            return this;
        }

        public BaseGeneratorBuilder maxBlockCount(int value) {
            this.maxBlockCount = value;
            return this;
        }

        public BaseGeneratorBuilder function(Int2DoubleFunction value) {
            this.function = value;
            return this;
        }

        public Optional<BaseGenerator> tryBuild() {
            if (this.blockCount == null || this.maxBlockCount == null || this.function == null) {
                return Optional.empty();
            }
            return Optional.of(new BaseGenerator(this.blockCount, this.maxBlockCount, this.function));
        }
    }

    private record UniformFunction(int minY, int maxY) implements Int2DoubleFunction
    {
        public double get(int y) {
            return this.minY <= y && y <= this.maxY ? 1.0 : 0.0;
        }
    }

    private record TrapezoidFunction(int minY, int minL, int l, int maxL, int maxY) implements Int2DoubleFunction
    {
        public double get(int y) {
            if (y >= this.minY) {
                if (y < this.minL) {
                    return (0.0 + (double)y - (double)this.minY) / (double)this.l;
                }
                if (y <= this.maxL) {
                    return 1.0;
                }
                if (y <= this.maxY) {
                    return (0.0 + (double)this.l - (double)y + (double)this.minY) / (double)this.l;
                }
            }
            return 0.0;
        }
    }

    private record BaseGenerator(int blockCount, int maxBlockCount, Int2DoubleFunction function) {
    }
}

