/*
 * Decompiled with CFR 0.152.
 */
package dev.maxoduke.mods.potioncauldron.block;

import dev.maxoduke.mods.potioncauldron.PotionCauldron;
import dev.maxoduke.mods.potioncauldron.block.PotionCauldronBlockEntity;
import dev.maxoduke.mods.potioncauldron.config.ServerConfig;
import dev.maxoduke.mods.potioncauldron.util.ParticleUtils;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotionCauldronBlock
extends LayeredCauldronBlock
implements EntityBlock {
    public PotionCauldronBlock(CauldronInteraction.InteractionMap interactionMap, BlockBehaviour.Properties properties) {
        super(Biome.Precipitation.RAIN, interactionMap, properties);
    }

    public void handlePrecipitation(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Biome.Precipitation precipitation) {
        if (PotionCauldron.CONFIG_MANAGER.serverConfig().shouldAllowFillingWithWaterDrips()) {
            super.handlePrecipitation(state, level, pos, precipitation);
        }
    }

    protected void receiveStalactiteDrip(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Fluid fluid) {
        if (PotionCauldron.CONFIG_MANAGER.serverConfig().shouldAllowFillingWithWaterDrips()) {
            super.receiveStalactiteDrip(state, level, pos, fluid);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new PotionCauldronBlockEntity(pos, state);
    }

    public void entityInside(@NotNull BlockState blockState, Level level, @NotNull BlockPos blockPos, @NotNull Entity entity, @NotNull InsideBlockEffectApplier insideBlockEffectApplier, boolean bl) {
        ServerConfig serverConfig;
        if (level.isClientSide() || !(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (livingEntity instanceof ArmorStand) {
            return;
        }
        if (livingEntity.isOnFire()) {
            livingEntity.clearFire();
            if (livingEntity.mayInteract((ServerLevel)level, blockPos)) {
                this.handleEntityOnFireInside(blockState, level, blockPos);
            }
        }
        if (!(serverConfig = PotionCauldron.CONFIG_MANAGER.serverConfig()).shouldApplyPotionEffectsToEntitiesInside()) {
            return;
        }
        PotionCauldronBlockEntity blockEntity = (PotionCauldronBlockEntity)level.getBlockEntity(blockPos);
        if (blockEntity == null) {
            return;
        }
        Holder<Potion> potionHolder = blockEntity.getPotion();
        if (potionHolder == null) {
            return;
        }
        Potion potion = (Potion)potionHolder.value();
        if (potion.hasInstantEffects()) {
            return;
        }
        for (MobEffectInstance potionEffect : potion.getEffects()) {
            boolean isPlayerAndCreative;
            Holder effect = potionEffect.getEffect();
            if (livingEntity.hasEffect(effect)) continue;
            int duration = potionEffect.getDuration();
            boolean isPlayer = livingEntity instanceof ServerPlayer;
            boolean bl2 = isPlayerAndCreative = isPlayer && ((ServerPlayer)livingEntity).isCreative();
            if (!isPlayer || !isPlayerAndCreative) {
                PotionCauldronBlock.lowerFillLevel((BlockState)level.getBlockState(blockPos), (Level)level, (BlockPos)blockPos);
            }
            MobEffectInstance effectInstance = new MobEffectInstance(potionEffect.getEffect(), duration, potionEffect.getAmplifier());
            livingEntity.addEffect(effectInstance);
        }
    }

    public void animateTick(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        PotionCauldronBlockEntity blockEntity = (PotionCauldronBlockEntity)level.getBlockEntity(pos);
        if (blockEntity == null) {
            return;
        }
        Holder<Potion> potion = blockEntity.getPotion();
        if (potion == null) {
            return;
        }
        OptionalInt particleColor = PotionContents.getColorOptional((Iterable)((Potion)potion.value()).getEffects());
        if (particleColor.isEmpty()) {
            return;
        }
        ParticleUtils.generatePotionParticles(level, pos, particleColor.getAsInt(), false);
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull LevelReader reader, @NotNull BlockPos blockPos, @NotNull BlockState blockState, boolean bl) {
        return new ItemStack((ItemLike)Items.CAULDRON);
    }
}

