/*
 * Decompiled with CFR 0.152.
 */
package dev.maxoduke.mods.potioncauldron.block;

import dev.maxoduke.mods.potioncauldron.PotionCauldron;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotionCauldronBlockEntity
extends BlockEntity {
    private Holder<Potion> potion = Potions.FIRE_RESISTANCE;
    private String potionType = BuiltInRegistries.ITEM.getKey((Object)Items.POTION).toString();

    public PotionCauldronBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)PotionCauldron.BLOCK_ENTITY.get(), blockPos, blockState);
    }

    @Nullable
    public Holder<Potion> getPotion() {
        return this.potion;
    }

    public void setPotion(Holder<Potion> potion) {
        this.potion = potion;
    }

    @NotNull
    public String getPotionType() {
        return this.potionType;
    }

    public void setPotionType(String potionType) {
        this.potionType = potionType;
    }

    public void loadAdditional(ValueInput valueInput) {
        Optional optionalOptionNameResourceLocation = valueInput.getString("PotionName");
        Optional optionalPotionType = valueInput.getString("PotionType");
        if (optionalOptionNameResourceLocation.isEmpty() || optionalPotionType.isEmpty()) {
            return;
        }
        ResourceLocation potionNameResourceLocation = ResourceLocation.tryParse((String)((String)optionalOptionNameResourceLocation.get()));
        if (potionNameResourceLocation == null) {
            return;
        }
        Optional holder = BuiltInRegistries.POTION.get(potionNameResourceLocation);
        if (holder.isEmpty()) {
            return;
        }
        this.potion = (Holder)holder.get();
        this.potionType = (String)optionalPotionType.get();
    }

    protected void saveAdditional(@NotNull ValueOutput valueOutput) {
        if (this.potion == null) {
            return;
        }
        ResourceLocation potionResource = BuiltInRegistries.POTION.getKey((Object)((Potion)this.potion.value()));
        if (potionResource == null) {
            return;
        }
        String potionName = potionResource.toString();
        valueOutput.putString("PotionName", potionName);
        valueOutput.putString("PotionType", this.potionType);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.saveWithFullMetadata(provider);
    }
}

