/*
 * Decompiled with CFR 0.152.
 */
package dev.maxoduke.mods.potioncauldron.block;

import dev.maxoduke.mods.potioncauldron.PotionCauldron;
import dev.maxoduke.mods.potioncauldron.block.PotionCauldronBlock;
import dev.maxoduke.mods.potioncauldron.block.PotionCauldronBlockEntity;
import dev.maxoduke.mods.potioncauldron.networking.ServerNetworking;
import dev.maxoduke.mods.potioncauldron.networking.payloads.ParticlePayload;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class PotionCauldronBlockInteraction {
    public static final CauldronInteraction.InteractionMap INTERACTION_MAP = CauldronInteraction.newInteractionMap((String)"PotionCauldronInteractionMap");
    public static final Map<Item, CauldronInteraction> MAP = INTERACTION_MAP.map();

    public static void bootstrap() {
        CauldronInteraction.EMPTY.map().put(Items.SPLASH_POTION, PotionCauldronBlockInteraction::fillEmptyCauldronWithPotion);
        CauldronInteraction.EMPTY.map().put(Items.LINGERING_POTION, PotionCauldronBlockInteraction::fillEmptyCauldronWithPotion);
        MAP.put(Items.POTION, PotionCauldronBlockInteraction::fillPotionCauldronWithPotion);
        MAP.put(Items.SPLASH_POTION, PotionCauldronBlockInteraction::fillPotionCauldronWithPotion);
        MAP.put(Items.LINGERING_POTION, PotionCauldronBlockInteraction::fillPotionCauldronWithPotion);
        MAP.put(Items.WATER_BUCKET, PotionCauldronBlockInteraction::fillPotionCauldronWithWaterOrLavaBucket);
        MAP.put(Items.LAVA_BUCKET, PotionCauldronBlockInteraction::fillPotionCauldronWithWaterOrLavaBucket);
        MAP.put(Items.GLASS_BOTTLE, PotionCauldronBlockInteraction::fillBottleFromPotionCauldron);
        MAP.put(Items.ARROW, PotionCauldronBlockInteraction::createTippedArrowsFromPotionCauldron);
    }

    public static InteractionResult fillEmptyCauldronWithPotion(BlockState ignored, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, ItemStack itemStack) {
        ResourceLocation potionTypeResource = ResourceLocation.tryParse((String)itemStack.getItem().toString());
        PotionContents potionContents = (PotionContents)itemStack.get(DataComponents.POTION_CONTENTS);
        Optional potionHolder = potionContents.potion();
        if (potionHolder.isEmpty()) {
            return InteractionResult.PASS;
        }
        Holder potion = (Holder)potionHolder.get();
        String potionType = potionTypeResource.toString();
        if (potion == Potions.WATER || potion == Potions.AWKWARD || potion == Potions.MUNDANE || potion == Potions.THICK) {
            return InteractionResult.PASS;
        }
        level.setBlockAndUpdate(blockPos, ((PotionCauldronBlock)((Object)PotionCauldron.BLOCK.get())).defaultBlockState());
        PotionCauldronBlockEntity blockEntity = (PotionCauldronBlockEntity)level.getBlockEntity(blockPos);
        blockEntity.setPotion((Holder<Potion>)potion);
        blockEntity.setPotionType(potionType);
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        OptionalInt particleColor = PotionContents.getColorOptional((Iterable)((Potion)potion.value()).getEffects());
        if (particleColor.isPresent()) {
            ServerNetworking.sendParticlesToClients(new ParticlePayload(ParticleTypes.ENTITY_EFFECT, blockPos, particleColor.getAsInt(), true));
        }
        player.setItemInHand(interactionHand, ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE)));
        level.playSound(null, blockPos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, blockPos);
        return InteractionResult.SUCCESS_SERVER;
    }

    private static InteractionResult fillPotionCauldronWithPotion(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, ItemStack itemStack) {
        ResourceLocation potionTypeResource = ResourceLocation.tryParse((String)itemStack.getItem().toString());
        if (potionTypeResource == null) {
            return InteractionResult.PASS;
        }
        PotionContents potionContents = (PotionContents)itemStack.get(DataComponents.POTION_CONTENTS);
        if (potionContents == null) {
            return InteractionResult.PASS;
        }
        Optional potionHolder = potionContents.potion();
        if (potionHolder.isEmpty()) {
            return InteractionResult.PASS;
        }
        Holder potionInHand = (Holder)potionHolder.get();
        String potionTypeInHand = potionTypeResource.toString();
        if (potionInHand == Potions.WATER || potionInHand == Potions.AWKWARD || potionInHand == Potions.MUNDANE || potionInHand == Potions.THICK) {
            return InteractionResult.PASS;
        }
        if ((Integer)blockState.getValue((Property)LayeredCauldronBlock.LEVEL) == 3) {
            return InteractionResult.PASS;
        }
        PotionCauldronBlockEntity blockEntity = (PotionCauldronBlockEntity)level.getBlockEntity(blockPos);
        Holder<Potion> potionInCauldron = blockEntity.getPotion();
        String potionTypeInCauldron = blockEntity.getPotionType();
        if (potionInCauldron != potionInHand) {
            return PotionCauldronBlockInteraction.handlePotionMixing(level, blockPos, player, interactionHand, itemStack);
        }
        if (!potionTypeInCauldron.equals(potionTypeInHand)) {
            if (!PotionCauldron.CONFIG_MANAGER.clientOrServerConfig().shouldAllowMergingPotions()) {
                return PotionCauldronBlockInteraction.handlePotionMixing(level, blockPos, player, interactionHand, itemStack);
            }
            blockEntity.setPotionType(potionTypeInHand);
        }
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        level.setBlockAndUpdate(blockPos, (BlockState)blockState.cycle((Property)LayeredCauldronBlock.LEVEL));
        OptionalInt particleColor = PotionContents.getColorOptional((Iterable)((Potion)potionInCauldron.value()).getEffects());
        if (particleColor.isPresent()) {
            ServerNetworking.sendParticlesToClients(new ParticlePayload(ParticleTypes.ENTITY_EFFECT, blockPos, particleColor.getAsInt(), true));
        }
        player.setItemInHand(interactionHand, ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE)));
        level.playSound(null, blockPos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, blockPos);
        return InteractionResult.SUCCESS_SERVER;
    }

    private static InteractionResult fillPotionCauldronWithWaterOrLavaBucket(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, ItemStack itemStack) {
        return PotionCauldronBlockInteraction.handlePotionMixing(level, blockPos, player, interactionHand, itemStack);
    }

    private static InteractionResult fillBottleFromPotionCauldron(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, ItemStack itemStack) {
        Optional potionTypeHolder;
        if ((Integer)blockState.getValue((Property)LayeredCauldronBlock.LEVEL) == 0) {
            return InteractionResult.PASS;
        }
        PotionCauldronBlockEntity blockEntity = (PotionCauldronBlockEntity)level.getBlockEntity(blockPos);
        if (blockEntity == null) {
            return InteractionResult.PASS;
        }
        Holder<Potion> potion = blockEntity.getPotion();
        if (potion == null) {
            return InteractionResult.PASS;
        }
        ResourceLocation potionTypeResourceLocation = ResourceLocation.tryParse((String)blockEntity.getPotionType());
        if (potionTypeResourceLocation == null) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        OptionalInt particleColor = PotionContents.getColorOptional((Iterable)((Potion)potion.value()).getEffects());
        if (particleColor.isPresent()) {
            ServerNetworking.sendParticlesToClients(new ParticlePayload(ParticleTypes.ENTITY_EFFECT, blockPos, particleColor.getAsInt(), true));
        }
        if ((potionTypeHolder = BuiltInRegistries.ITEM.get(potionTypeResourceLocation)).isEmpty()) {
            return InteractionResult.PASS;
        }
        Item potionType = (Item)((Holder.Reference)potionTypeHolder.get()).value();
        player.setItemInHand(interactionHand, ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)PotionContents.createItemStack((Item)potionType, potion)));
        LayeredCauldronBlock.lowerFillLevel((BlockState)blockState, (Level)level, (BlockPos)blockPos);
        level.playSound(null, blockPos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.gameEvent(null, (Holder)GameEvent.FLUID_PICKUP, blockPos);
        return InteractionResult.SUCCESS_SERVER;
    }

    private static InteractionResult createTippedArrowsFromPotionCauldron(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand ignored, ItemStack stack) {
        Inventory inventory;
        if (!PotionCauldron.CONFIG_MANAGER.clientOrServerConfig().shouldAllowCreatingTippedArrows()) {
            return InteractionResult.PASS;
        }
        if ((Integer)blockState.getValue((Property)LayeredCauldronBlock.LEVEL) == 0) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        HashMap<Integer, Integer> cauldronLevelToArrows = PotionCauldron.CONFIG_MANAGER.serverConfig().maxTippedArrowsPerLevel();
        int currentCauldronLevel = (Integer)blockState.getValue((Property)LayeredCauldronBlock.LEVEL);
        int maxTippedArrowCount = cauldronLevelToArrows.get(currentCauldronLevel);
        int tippedArrowCount = Math.min(stack.getCount(), maxTippedArrowCount);
        int usedCauldronLevels = -1;
        for (Map.Entry<Integer, Integer> item : cauldronLevelToArrows.entrySet()) {
            if (tippedArrowCount > item.getValue()) continue;
            usedCauldronLevels = item.getKey();
            break;
        }
        int remainingCauldronLevels = currentCauldronLevel - usedCauldronLevels;
        PotionCauldronBlockEntity blockEntity = (PotionCauldronBlockEntity)level.getBlockEntity(blockPos);
        Holder<Potion> potion = blockEntity.getPotion();
        ItemStack tippedArrows = new ItemStack((ItemLike)Items.TIPPED_ARROW);
        tippedArrows.setCount(tippedArrowCount);
        tippedArrows.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(potion));
        OptionalInt particleColor = PotionContents.getColorOptional((Iterable)((Potion)potion.value()).getEffects());
        if (particleColor.isPresent()) {
            ServerNetworking.sendParticlesToClients(new ParticlePayload(ParticleTypes.ENTITY_EFFECT, blockPos, particleColor.getAsInt(), true));
        }
        level.setBlockAndUpdate(blockPos, remainingCauldronLevels == 0 ? Blocks.CAULDRON.defaultBlockState() : (BlockState)blockState.setValue((Property)PotionCauldronBlock.LEVEL, (Comparable)Integer.valueOf(remainingCauldronLevels)));
        if (!player.isCreative()) {
            stack.shrink(tippedArrowCount);
        }
        if (!(inventory = player.getInventory()).add(tippedArrows)) {
            player.drop(tippedArrows, false);
        }
        level.playSound(null, blockPos, SoundEvents.GENERIC_SPLASH, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.gameEvent(null, (Holder)GameEvent.FLUID_PICKUP, blockPos);
        return InteractionResult.SUCCESS_SERVER;
    }

    private static InteractionResult handlePotionMixing(Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, ItemStack itemStack) {
        if (!PotionCauldron.CONFIG_MANAGER.clientOrServerConfig().shouldEvaporatePotionWhenMixed()) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        ServerNetworking.sendParticlesToClients(new ParticlePayload((ParticleType<?>)ParticleTypes.POOF, blockPos));
        level.setBlockAndUpdate(blockPos, Blocks.CAULDRON.defaultBlockState());
        ItemStack itemToGiveBack = itemStack.getItem() == Items.WATER_BUCKET || itemStack.getItem() == Items.LAVA_BUCKET ? new ItemStack((ItemLike)Items.BUCKET) : new ItemStack((ItemLike)Items.GLASS_BOTTLE);
        player.setItemInHand(interactionHand, ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)itemToGiveBack));
        level.playSound(null, blockPos, (SoundEvent)PotionCauldron.POTION_EVAPORATES_SOUND_EVENT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, blockPos);
        return InteractionResult.SUCCESS_SERVER;
    }
}

