/*
 * Decompiled with CFR 0.152.
 */
package dev.maxoduke.mods.potioncauldron.config.gui;

import dev.maxoduke.mods.potioncauldron.config.ServerConfig;
import dev.maxoduke.mods.potioncauldron.config.exceptions.InvalidConfigValueException;
import dev.maxoduke.mods.potioncauldron.config.gui.ConfigScreen;
import dev.maxoduke.mods.potioncauldron.config.gui.entries.AddPotionColumnTitlesEntry;
import dev.maxoduke.mods.potioncauldron.config.gui.entries.AddPotionEntry;
import dev.maxoduke.mods.potioncauldron.config.gui.entries.BlankEntry;
import dev.maxoduke.mods.potioncauldron.config.gui.entries.EditboxEntry;
import dev.maxoduke.mods.potioncauldron.config.gui.entries.LabelEntry;
import dev.maxoduke.mods.potioncauldron.config.gui.entries.OnOffButtonEntry;
import dev.maxoduke.mods.potioncauldron.config.gui.entries.PotionEntry;
import dev.maxoduke.mods.potioncauldron.util.ProbabilityUtils;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;

public class ConfigList
extends ContainerObjectSelectionList<Entry> {
    private static final Component EVAPORATE_POTION_WHEN_MIXED = Component.translatable((String)"config.text.evaporatePotionWhenMixed");
    private static final Component ALLOW_MERGING_POTIONS = Component.translatable((String)"config.text.allowMergingPotions");
    private static final Component APPLY_POTION_EFFECTS = Component.translatable((String)"config.text.applyPotionEffectsToEntitiesInside");
    private static final Component ALLOW_FILLING_WITH_WATER_DRIPS = Component.translatable((String)"config.text.allowFillingWithWaterDrips");
    private static final Component ALLOW_CREATING_TIPPED_ARROWS = Component.translatable((String)"config.text.allowCreatingTippedArrows");
    private static final Component MAX_TIPPED_ARROWS_PER_LEVEL = Component.translatable((String)"config.text.maxTippedArrowsPerLevel");
    private static final Component GENERATE_IN_SWAMP_HUTS = Component.translatable((String)"config.text.generateInSwampHuts");
    private static final Component POTION_TYPES_PERCENTAGE = Component.translatable((String)"config.text.potionTypesPercentage");
    private static final Component NORMAL_POTION = Component.translatable((String)"config.text.normalPotion");
    private static final Component SPLASH_POTION = Component.translatable((String)"config.text.splashPotion");
    private static final Component LINGERING_POTION = Component.translatable((String)"config.text.lingeringPotion");
    private static final Component POTION_LEVELS_PERCENTAGE = Component.translatable((String)"config.text.potionLevelsPercentage");
    private static final Component LEVEL_1 = Component.translatable((String)"config.text.level_1");
    private static final Component LEVEL_2 = Component.translatable((String)"config.text.level_2");
    private static final Component LEVEL_3 = Component.translatable((String)"config.text.level_3");
    private static final Component POTIONS_PERCENTAGE = Component.translatable((String)"config.text.potionsPercentage");
    private final Font font;
    private final ServerConfig config;
    private final Runnable onChange;
    private final LabelEntry maxTippedArrowsPerLevelLabelEntry;
    private final EditboxEntry level1MaxTippedArrowsEntry;
    private final EditboxEntry level2MaxTippedArrowsEntry;
    private final EditboxEntry level3MaxTippedArrowsEntry;
    private final LabelEntry potionTypesLabelEntry;
    private final EditboxEntry normalPotionEntry;
    private final EditboxEntry splashPotionEntry;
    private final EditboxEntry lingeringPotionEntry;
    private final LabelEntry potionLevelsLabelEntry;
    private final EditboxEntry level1Entry;
    private final EditboxEntry level2Entry;
    private final EditboxEntry level3Entry;
    private final AddPotionEntry addPotionEntry;
    private static final int ENTRY_HEIGHT = 25;
    private static final int TOP = 50;

    public ConfigList(ConfigScreen screen, Font font, ServerConfig config, Runnable onChange) {
        super(Minecraft.getInstance(), screen.width, screen.height - 100, 50, 25);
        this.config = config;
        this.font = font;
        this.onChange = onChange;
        boolean evaporatePotionWhenMixed = config.shouldEvaporatePotionWhenMixed();
        boolean allowMergingPotions = config.shouldAllowMergingPotions();
        boolean applyPotionEffects = config.shouldApplyPotionEffectsToEntitiesInside();
        boolean allowFillingWithWaterDrips = config.shouldAllowFillingWithWaterDrips();
        boolean allowCreatingTippedArrows = config.shouldAllowCreatingTippedArrows();
        boolean generateInSwampHuts = config.shouldGenerateInSwampHuts();
        this.addEntry((AbstractSelectionList.Entry)new OnOffButtonEntry(font, EVAPORATE_POTION_WHEN_MIXED, evaporatePotionWhenMixed, (CycleButton.OnValueChange<Boolean>)((CycleButton.OnValueChange)this::toggleEvaporatePotionWhenMixed)));
        this.addEntry((AbstractSelectionList.Entry)new OnOffButtonEntry(font, ALLOW_MERGING_POTIONS, allowMergingPotions, (CycleButton.OnValueChange<Boolean>)((CycleButton.OnValueChange)this::toggleAllowMergingPotions)));
        this.addEntry((AbstractSelectionList.Entry)new OnOffButtonEntry(font, APPLY_POTION_EFFECTS, applyPotionEffects, (CycleButton.OnValueChange<Boolean>)((CycleButton.OnValueChange)this::toggleApplyPotionEffects)));
        this.addEntry((AbstractSelectionList.Entry)new OnOffButtonEntry(font, ALLOW_FILLING_WITH_WATER_DRIPS, allowFillingWithWaterDrips, (CycleButton.OnValueChange<Boolean>)((CycleButton.OnValueChange)this::toggleAllowFillingWithWaterDrips)));
        this.addEntry((AbstractSelectionList.Entry)new BlankEntry(font));
        this.addEntry((AbstractSelectionList.Entry)new OnOffButtonEntry(font, ALLOW_CREATING_TIPPED_ARROWS, allowCreatingTippedArrows, (CycleButton.OnValueChange<Boolean>)((CycleButton.OnValueChange)this::toggleAllowCreatingTippedArrows)));
        this.maxTippedArrowsPerLevelLabelEntry = new LabelEntry(font, MAX_TIPPED_ARROWS_PER_LEVEL, 20);
        this.addEntry((AbstractSelectionList.Entry)this.maxTippedArrowsPerLevelLabelEntry);
        this.level1MaxTippedArrowsEntry = new EditboxEntry(font, LEVEL_1, 40, allowCreatingTippedArrows, String.valueOf(config.getMaxTippedArrowsForLevel1()), this::validateAndUpdateMaxTippedArrowsPerLevel);
        this.addEntry((AbstractSelectionList.Entry)this.level1MaxTippedArrowsEntry);
        this.level2MaxTippedArrowsEntry = new EditboxEntry(font, LEVEL_2, 40, allowCreatingTippedArrows, String.valueOf(config.getMaxTippedArrowsForLevel2()), this::validateAndUpdateMaxTippedArrowsPerLevel);
        this.addEntry((AbstractSelectionList.Entry)this.level2MaxTippedArrowsEntry);
        this.level3MaxTippedArrowsEntry = new EditboxEntry(font, LEVEL_3, 40, allowCreatingTippedArrows, String.valueOf(config.getMaxTippedArrowsForLevel3()), this::validateAndUpdateMaxTippedArrowsPerLevel);
        this.addEntry((AbstractSelectionList.Entry)this.level3MaxTippedArrowsEntry);
        this.addEntry((AbstractSelectionList.Entry)new BlankEntry(font));
        this.addEntry((AbstractSelectionList.Entry)new OnOffButtonEntry(font, GENERATE_IN_SWAMP_HUTS, generateInSwampHuts, (CycleButton.OnValueChange<Boolean>)((CycleButton.OnValueChange)this::toggleGenerateInSwampHuts)));
        String normalPotionChance = ProbabilityUtils.toPercentageString(config.getNormalPotionChance());
        String splashPotionChance = ProbabilityUtils.toPercentageString(config.getSplashPotionChance());
        String lingeringPotionChance = ProbabilityUtils.toPercentageString(config.getLingeringPotionChance());
        this.potionTypesLabelEntry = new LabelEntry(font, POTION_TYPES_PERCENTAGE, 20);
        this.addEntry((AbstractSelectionList.Entry)this.potionTypesLabelEntry);
        this.normalPotionEntry = new EditboxEntry(font, NORMAL_POTION, 40, generateInSwampHuts, normalPotionChance, this::validateAndUpdatePotionTypes);
        this.addEntry((AbstractSelectionList.Entry)this.normalPotionEntry);
        this.splashPotionEntry = new EditboxEntry(font, SPLASH_POTION, 40, generateInSwampHuts, splashPotionChance, this::validateAndUpdatePotionTypes);
        this.addEntry((AbstractSelectionList.Entry)this.splashPotionEntry);
        this.lingeringPotionEntry = new EditboxEntry(font, LINGERING_POTION, 40, generateInSwampHuts, lingeringPotionChance, this::validateAndUpdatePotionTypes);
        this.addEntry((AbstractSelectionList.Entry)this.lingeringPotionEntry);
        String level1Chance = ProbabilityUtils.toPercentageString(config.getLevel1Chance());
        String level2Chance = ProbabilityUtils.toPercentageString(config.getLevel2Chance());
        String level3Chance = ProbabilityUtils.toPercentageString(config.getLevel3Chance());
        this.potionLevelsLabelEntry = new LabelEntry(font, POTION_LEVELS_PERCENTAGE, 20);
        this.addEntry((AbstractSelectionList.Entry)this.potionLevelsLabelEntry);
        this.level1Entry = new EditboxEntry(font, LEVEL_1, 40, generateInSwampHuts, level1Chance, this::validateAndUpdatePotionLevels);
        this.addEntry((AbstractSelectionList.Entry)this.level1Entry);
        this.level2Entry = new EditboxEntry(font, LEVEL_2, 40, generateInSwampHuts, level2Chance, this::validateAndUpdatePotionLevels);
        this.addEntry((AbstractSelectionList.Entry)this.level2Entry);
        this.level3Entry = new EditboxEntry(font, LEVEL_3, 40, generateInSwampHuts, level3Chance, this::validateAndUpdatePotionLevels);
        this.addEntry((AbstractSelectionList.Entry)this.level3Entry);
        this.addEntry((AbstractSelectionList.Entry)new LabelEntry(font, POTIONS_PERCENTAGE, 20));
        this.addEntry((AbstractSelectionList.Entry)new AddPotionColumnTitlesEntry(font, 40));
        this.addPotionEntry = new AddPotionEntry(font, 40, this::validatePotionEntries, this::addPotionEntry);
        this.addEntry((AbstractSelectionList.Entry)this.addPotionEntry);
        for (Map.Entry<String, Double> potionChance : config.potionChances().entrySet()) {
            String name = potionChance.getKey();
            double chance = potionChance.getValue();
            this.addEntry((AbstractSelectionList.Entry)new PotionEntry(font, 40, name, chance, this::removePotionEntry));
        }
    }

    protected int scrollBarX() {
        return super.scrollBarX() + 50;
    }

    public int getRowWidth() {
        return 300;
    }

    public boolean isValid() {
        return this.maxTippedArrowsPerLevelLabelEntry.isValid() && this.potionTypesLabelEntry.isValid() && this.potionLevelsLabelEntry.isValid();
    }

    public void toggleEvaporatePotionWhenMixed(CycleButton<Boolean> ignored, boolean newValue) {
        this.config.setEvaporatePotionWhenMixed(newValue);
        this.onChange.run();
    }

    public void toggleAllowMergingPotions(CycleButton<Boolean> ignored, boolean newValue) {
        this.config.setAllowMergingPotions(newValue);
        this.onChange.run();
    }

    public void toggleApplyPotionEffects(CycleButton<Boolean> ignored, boolean newValue) {
        this.config.setApplyPotionEffectsToEntitiesInside(newValue);
        this.onChange.run();
    }

    public void toggleAllowFillingWithWaterDrips(CycleButton<Boolean> ignored, boolean newValue) {
        this.config.setAllowFillingWithWaterDrips(newValue);
        this.onChange.run();
    }

    public void toggleAllowCreatingTippedArrows(CycleButton<Boolean> ignored, boolean newValue) {
        this.config.setAllowCreatingTippedArrows(newValue);
        this.level1MaxTippedArrowsEntry.enable(newValue);
        this.level2MaxTippedArrowsEntry.enable(newValue);
        this.level3MaxTippedArrowsEntry.enable(newValue);
        this.onChange.run();
    }

    public void toggleGenerateInSwampHuts(CycleButton<Boolean> ignored, boolean newValue) {
        this.config.setGenerateInSwampHuts(newValue);
        this.normalPotionEntry.enable(newValue);
        this.splashPotionEntry.enable(newValue);
        this.lingeringPotionEntry.enable(newValue);
        this.level1Entry.enable(newValue);
        this.level2Entry.enable(newValue);
        this.level3Entry.enable(newValue);
        this.onChange.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateAndUpdateMaxTippedArrowsPerLevel(String ignored) {
        try {
            int level1MaxTippedArrows = Integer.parseInt(this.level1MaxTippedArrowsEntry.getValue());
            int level2MaxTippedArrows = Integer.parseInt(this.level2MaxTippedArrowsEntry.getValue());
            int level3MaxTippedArrows = Integer.parseInt(this.level3MaxTippedArrowsEntry.getValue());
            int maxStackSize = Items.TIPPED_ARROW.getDefaultMaxStackSize();
            if (level1MaxTippedArrows > maxStackSize || level2MaxTippedArrows > maxStackSize || level3MaxTippedArrows > maxStackSize) {
                throw new InvalidConfigValueException("Total exceeds the maximum stack size of %d".formatted(maxStackSize));
            }
            if (level1MaxTippedArrows < 0 || level2MaxTippedArrows < 0 || level3MaxTippedArrows < 0) {
                throw new InvalidConfigValueException("Size cannot be less than 0");
            }
            if (level1MaxTippedArrows >= level2MaxTippedArrows || level2MaxTippedArrows >= level3MaxTippedArrows) {
                throw new InvalidConfigValueException("Higher cauldron level cannot create lower amount of tipped arrows");
            }
            this.maxTippedArrowsPerLevelLabelEntry.clearError();
            this.config.setMaxTippedArrowsForLevel1(level1MaxTippedArrows);
            this.config.setMaxTippedArrowsForLevel2(level2MaxTippedArrows);
            this.config.setMaxTippedArrowsForLevel3(level3MaxTippedArrows);
        }
        catch (InvalidConfigValueException | NumberFormatException ex) {
            this.maxTippedArrowsPerLevelLabelEntry.setError(ex instanceof NumberFormatException ? "Invalid number specified" : ex.getMessage());
        }
        finally {
            this.onChange.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateAndUpdatePotionTypes(String ignored) {
        try {
            BigDecimal normalPotionChance = BigDecimal.valueOf(ProbabilityUtils.toDouble(this.normalPotionEntry.getValue()));
            BigDecimal splashPotionChance = BigDecimal.valueOf(ProbabilityUtils.toDouble(this.splashPotionEntry.getValue()));
            BigDecimal lingeringPotionChance = BigDecimal.valueOf(ProbabilityUtils.toDouble(this.lingeringPotionEntry.getValue()));
            double totalPercentage = normalPotionChance.add(splashPotionChance).add(lingeringPotionChance).doubleValue();
            if (totalPercentage != 1.0) {
                throw new InvalidConfigValueException("Total % must add up to 100%");
            }
            this.potionTypesLabelEntry.clearError();
            this.config.setNormalPotionChance(normalPotionChance.doubleValue());
            this.config.setSplashPotionChance(splashPotionChance.doubleValue());
            this.config.setLingeringPotionChance(lingeringPotionChance.doubleValue());
        }
        catch (InvalidConfigValueException | NumberFormatException ex) {
            this.potionTypesLabelEntry.setError(ex instanceof NumberFormatException ? "Invalid % specified" : ex.getMessage());
        }
        finally {
            this.onChange.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateAndUpdatePotionLevels(String ignored) {
        try {
            BigDecimal level1Chance = BigDecimal.valueOf(ProbabilityUtils.toDouble(this.level1Entry.getValue()));
            BigDecimal level2Chance = BigDecimal.valueOf(ProbabilityUtils.toDouble(this.level2Entry.getValue()));
            BigDecimal level3Chance = BigDecimal.valueOf(ProbabilityUtils.toDouble(this.level3Entry.getValue()));
            double totalPercentage = level1Chance.add(level2Chance).add(level3Chance).doubleValue();
            if (totalPercentage != 1.0) {
                throw new InvalidConfigValueException("Total % must add up to 100%");
            }
            this.potionLevelsLabelEntry.clearError();
            this.config.setLevel1Chance(level1Chance.doubleValue());
            this.config.setLevel2Chance(level2Chance.doubleValue());
            this.config.setLevel3Chance(level3Chance.doubleValue());
        }
        catch (InvalidConfigValueException | NumberFormatException ex) {
            this.potionLevelsLabelEntry.setError(ex instanceof NumberFormatException ? "Invalid % specified" : ex.getMessage());
        }
        finally {
            this.onChange.run();
        }
    }

    public void validatePotionEntries(String ignored) {
        try {
            Map.Entry<String, Double> entry2;
            String potionName = this.addPotionEntry.getPotionName();
            Double potionChance = this.addPotionEntry.getPotionChance();
            if (potionName.isEmpty() || potionChance == null) {
                this.addPotionEntry.clearError();
                this.addPotionEntry.disableAddButton();
                return;
            }
            Optional potion = BuiltInRegistries.POTION.get(!potionName.contains(":") ? ResourceLocation.withDefaultNamespace((String)potionName) : ResourceLocation.parse((String)potionName));
            if (potion.isEmpty()) {
                throw new InvalidConfigValueException("Invalid potion name specified");
            }
            potionName = potionName.replace("minecraft:", "");
            for (Map.Entry<String, Double> entry2 : this.config.potionChances().entrySet()) {
                String key = entry2.getKey().replace("minecraft:", "");
                if (!key.equals(potionName)) continue;
                throw new InvalidConfigValueException("Potion already exists");
            }
            if (potionChance <= 0.0) {
                throw new InvalidConfigValueException("% must be more than 0");
            }
            BigDecimal totalChanceBD = BigDecimal.valueOf(potionChance);
            entry2 = this.config.potionChances().values().iterator();
            while (entry2.hasNext()) {
                double chance = (Double)entry2.next();
                totalChanceBD = totalChanceBD.add(BigDecimal.valueOf(chance));
            }
            double totalChance = totalChanceBD.doubleValue();
            if (totalChance > 1.0) {
                this.addPotionEntry.setError("Total % for potions exceeds 100%");
                return;
            }
            this.addPotionEntry.clearError();
        }
        catch (InvalidConfigValueException | NumberFormatException ex) {
            this.addPotionEntry.setError(ex instanceof NumberFormatException ? "Invalid % specified" : ex.getMessage());
        }
    }

    public void addPotionEntry(Button ignored) {
        String potionName = this.addPotionEntry.getPotionName();
        double potionChance = this.addPotionEntry.getPotionChance();
        this.addEntry((AbstractSelectionList.Entry)new PotionEntry(this.font, 40, potionName, potionChance, this::removePotionEntry));
        this.config.potionChances().put(potionName, potionChance);
        this.addPotionEntry.clear();
        this.onChange.run();
    }

    public void removePotionEntry(PotionEntry entry) {
        this.removeEntryFromTop((AbstractSelectionList.Entry)entry);
        this.config.potionChances().remove(entry.getPotionName());
        this.validatePotionEntries("");
        this.onChange.run();
    }

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        public static final Component EMPTY = Component.literal((String)"");
        protected static final Component ERROR_ICON = Component.literal((String)"(!)").withStyle(Style.EMPTY.withColor(0xFF0000).applyFormat(ChatFormatting.UNDERLINE));
    }
}

