/*
 * Decompiled with CFR 0.152.
 */
package dev.maxoduke.mods.potioncauldron.config.gui.entries;

import dev.maxoduke.mods.potioncauldron.config.gui.ConfigList;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class PotionEntry
extends ConfigList.Entry {
    private static final Component REMOVE = Component.translatable((String)"config.text.remove");
    private static final Component REMOVE_SIGN = Component.literal((String)"x");
    private final int leftIndent;
    private final String potionName;
    private final StringWidget potionNameWidget;
    private final StringWidget potionChanceWidget;
    private final Button removeButton;

    public PotionEntry(Font font, int leftIndent, String potionName, double potionChance, Consumer<PotionEntry> removeClickedListener) {
        this.leftIndent = leftIndent;
        this.potionName = potionName;
        String _potionChance = BigDecimal.valueOf(potionChance * 100.0).stripTrailingZeros().toPlainString();
        this.potionNameWidget = new StringWidget(150, 20, (Component)Component.literal((String)potionName), font);
        this.potionChanceWidget = new StringWidget(40, 20, (Component)Component.literal((String)_potionChance), font);
        this.removeButton = Button.builder((Component)REMOVE_SIGN, ignored -> removeClickedListener.accept(this)).tooltip(Tooltip.create((Component)REMOVE)).width(30).build();
    }

    public void renderContent(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, boolean bl, float partialTick) {
        int left = super.getX();
        int top = super.getY();
        this.potionNameWidget.setX(left + 4 + this.leftIndent);
        this.potionNameWidget.setY(top);
        this.potionNameWidget.render(guiGraphics, mouseX, mouseY, partialTick);
        this.potionChanceWidget.setX(left + 189 + this.leftIndent);
        this.potionChanceWidget.setY(top);
        this.potionChanceWidget.render(guiGraphics, mouseX, mouseY, partialTick);
        this.removeButton.setX(left + 228 + this.leftIndent);
        this.removeButton.setY(top);
        this.removeButton.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    @NotNull
    public List<? extends GuiEventListener> children() {
        return List.of(this.removeButton);
    }

    @NotNull
    public List<? extends NarratableEntry> narratables() {
        return Collections.emptyList();
    }

    public String getPotionName() {
        return this.potionName;
    }
}

