/*
 * Decompiled with CFR 0.152.
 */
package dev.maxoduke.mods.potioncauldron.networking;

import dev.maxoduke.mods.potioncauldron.PotionCauldron;
import dev.maxoduke.mods.potioncauldron.networking.payloads.ClientConfigPayload;
import dev.maxoduke.mods.potioncauldron.networking.payloads.ParticlePayload;
import dev.maxoduke.mods.potioncauldron.util.ParticleUtils;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.Level;

public class ClientNetworking {
    public static void clientDisconnected() {
        PotionCauldron.CONFIG_MANAGER.setClientConfig(null);
    }

    public static void receiveConfigFromServer(ClientConfigPayload config) {
        PotionCauldron.CONFIG_MANAGER.setClientConfig(config);
    }

    public static void receiveParticlesFromServer(ParticlePayload particleInfo) {
        ClientLevel level = Minecraft.getInstance().level;
        Optional<ParticleType<?>> particleTypeHolder = particleInfo.getParticleType();
        if (particleTypeHolder.isEmpty()) {
            return;
        }
        ParticleType<?> particleType = particleTypeHolder.get();
        if (particleType == ParticleTypes.ENTITY_EFFECT) {
            ParticleUtils.generatePotionParticles((Level)level, particleInfo.getBlockPos(), particleInfo.getColor(), particleInfo.shouldGenerateMultiple());
        } else if (particleType == ParticleTypes.POOF) {
            ParticleUtils.generateEvaporationParticles((Level)level, particleInfo.getBlockPos());
        }
    }
}

