/*
 * Decompiled with CFR 0.152.
 */
package dev.maxoduke.mods.potioncauldron.networking.payloads;

import dev.maxoduke.mods.potioncauldron.PotionCauldron;
import dev.maxoduke.mods.potioncauldron.config.IConfig;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import org.jetbrains.annotations.NotNull;

public class ClientConfigPayload
implements CustomPacketPayload,
IConfig {
    public static final CustomPacketPayload.Type<ClientConfigPayload> TYPE = new CustomPacketPayload.Type(PotionCauldron.CONFIG_CHANNEL);
    private final boolean evaporatePotionWhenMixed;
    private final boolean allowMergingPotions;
    private final boolean allowCreatingTippedArrows;

    public ClientConfigPayload(boolean evaporatePotionWhenMixed, boolean allowMergingPotions, boolean allowCreatingTippedArrows) {
        this.evaporatePotionWhenMixed = evaporatePotionWhenMixed;
        this.allowMergingPotions = allowMergingPotions;
        this.allowCreatingTippedArrows = allowCreatingTippedArrows;
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void writeToBuf(FriendlyByteBuf buf) {
        buf.writeBoolean(this.evaporatePotionWhenMixed);
        buf.writeBoolean(this.allowMergingPotions);
        buf.writeBoolean(this.allowCreatingTippedArrows);
    }

    public static ClientConfigPayload fromBuf(FriendlyByteBuf buf) {
        return new ClientConfigPayload(buf.readBoolean(), buf.readBoolean(), buf.readBoolean());
    }

    @Override
    public boolean shouldEvaporatePotionWhenMixed() {
        return this.evaporatePotionWhenMixed;
    }

    @Override
    public boolean shouldAllowMergingPotions() {
        return this.allowMergingPotions;
    }

    @Override
    public boolean shouldAllowCreatingTippedArrows() {
        return this.allowCreatingTippedArrows;
    }
}

