/*
 * Decompiled with CFR 0.152.
 */
package dev.maxoduke.mods.potioncauldron.networking.payloads;

import dev.maxoduke.mods.potioncauldron.PotionCauldron;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ParticlePayload
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<ParticlePayload> TYPE = new CustomPacketPayload.Type(PotionCauldron.PARTICLES_CHANNEL);
    private final String particleType;
    private final BlockPos blockPos;
    private final int color;
    private final boolean generateMultiple;

    public ParticlePayload(ParticleType<?> particleType, BlockPos blockPos) {
        this(particleType, blockPos, 0, false);
    }

    public ParticlePayload(ParticleType<?> particleType, BlockPos blockPos, int color, boolean generateMultiple) {
        this.particleType = BuiltInRegistries.PARTICLE_TYPE.getKey(particleType).toString();
        this.blockPos = blockPos;
        this.color = color;
        this.generateMultiple = generateMultiple;
    }

    public ParticlePayload(String particleType, BlockPos blockPos, int color, boolean generateMultiple) {
        this.particleType = particleType;
        this.blockPos = blockPos;
        this.color = color;
        this.generateMultiple = generateMultiple;
    }

    public void writeToBuf(FriendlyByteBuf buf) {
        buf.writeInt(this.particleType.length());
        buf.writeCharSequence((CharSequence)this.particleType, StandardCharsets.UTF_8);
        buf.writeNullable((Object)this.blockPos, (StreamEncoder)BlockPos.STREAM_CODEC);
        buf.writeInt(this.color);
        buf.writeBoolean(this.generateMultiple);
    }

    public static ParticlePayload fromBuf(FriendlyByteBuf buf) {
        return new ParticlePayload(buf.readCharSequence(buf.readInt(), StandardCharsets.UTF_8).toString(), (BlockPos)buf.readNullable((StreamDecoder)BlockPos.STREAM_CODEC), buf.readInt(), buf.readBoolean());
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public Optional<ParticleType<?>> getParticleType() {
        Optional holder = BuiltInRegistries.PARTICLE_TYPE.get(ResourceLocation.parse((String)this.particleType));
        if (holder.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((ParticleType)((Holder.Reference)holder.get()).value());
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public int getColor() {
        return this.color;
    }

    public boolean shouldGenerateMultiple() {
        return this.generateMultiple;
    }
}

