/*
 * Decompiled with CFR 0.152.
 */
package dev.maxoduke.mods.potioncauldron.block;

import dev.maxoduke.mods.potioncauldron.block.PotionCauldronBlock;
import dev.maxoduke.mods.potioncauldron.block.PotionCauldronBlockEntity;
import dev.maxoduke.mods.potioncauldron.block.PotionCauldronBlockEntityRenderState;
import java.util.OptionalInt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_4730;
import net.minecraft.class_5614;
import net.minecraft.class_6880;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class PotionCauldronBlockEntityRenderer
implements class_827<PotionCauldronBlockEntity, PotionCauldronBlockEntityRenderState> {
    private static final float[] FLUID_HEIGHT = new float[]{0.0f, 0.5625f, 0.75f, 0.9375f};
    private static final class_4730 WATER_MATERIAL = new class_4730(class_1059.field_5275, class_2960.method_60656((String)"block/water_still"));
    private static final class_1921 POTION_CAULDRON_BLOCK_RENDER_TYPE = class_1921.method_23580((class_2960)class_1059.field_5275);

    public PotionCauldronBlockEntityRenderer(class_5614.class_5615 ignored) {
    }

    @NotNull
    public PotionCauldronBlockEntityRenderState createRenderState() {
        return new PotionCauldronBlockEntityRenderState();
    }

    public void extractRenderState(PotionCauldronBlockEntity blockEntity, PotionCauldronBlockEntityRenderState blockEntityRenderState, float f, class_243 vec3, @Nullable class_11683.class_11792 crumblingOverlay) {
        super.method_74331((class_2586)blockEntity, (class_11954)blockEntityRenderState, f, vec3, crumblingOverlay);
        int liquidLevel = (Integer)blockEntity.method_11010().method_11654((class_2769)PotionCauldronBlock.field_27206);
        if (liquidLevel == 0) {
            return;
        }
        class_6880<class_1842> potion = blockEntity.getPotion();
        if (potion == null) {
            return;
        }
        OptionalInt spriteColor = class_1844.method_58111((Iterable)((class_1842)potion.comp_349()).method_8049());
        if (spriteColor.isEmpty()) {
            return;
        }
        blockEntityRenderState.setLiquidLevel(liquidLevel);
        blockEntityRenderState.setPotion(potion);
        blockEntityRenderState.setSpriteColor(spriteColor.getAsInt());
    }

    public void submit(PotionCauldronBlockEntityRenderState blockEntityRenderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        int liquidLevel = blockEntityRenderState.getLiquidLevel();
        class_6880<class_1842> potion = blockEntityRenderState.getPotion();
        int spriteColor = blockEntityRenderState.getSpriteColor();
        if (liquidLevel == 0 || potion == null || spriteColor == 0) {
            return;
        }
        int red = spriteColor >> 16 & 0xFF;
        int green = spriteColor >> 8 & 0xFF;
        int blue = spriteColor & 0xFF;
        int alpha = 190;
        class_1058 water = class_310.method_1551().method_72703().method_73030(WATER_MATERIAL);
        poseStack.method_22903();
        poseStack.method_46416(0.0f, FLUID_HEIGHT[liquidLevel] + 0.001f, 0.0f);
        float sizeFactor = 0.125f;
        float maxV = (water.method_4575() - water.method_4593()) * sizeFactor;
        float minV = (water.method_4575() - water.method_4593()) * (1.0f - sizeFactor);
        int PACKED_LIGHT = 0xF000F0;
        int PACKED_OVERLAY = class_4608.field_21444;
        submitNodeCollector.method_73483(poseStack, POTION_CAULDRON_BLOCK_RENDER_TYPE, (pose, consumer) -> {
            Matrix4f matrix = pose.method_23761();
            consumer.method_22918(matrix, sizeFactor, 0.0f, 1.0f - sizeFactor).method_1336(red, green, blue, alpha).method_22913(water.method_4594(), water.method_4593() + maxV).method_60803(0xF000F0).method_22922(PACKED_OVERLAY).method_22914(0.0f, 1.0f, 0.0f);
            consumer.method_22918(matrix, 1.0f - sizeFactor, 0.0f, 1.0f - sizeFactor).method_1336(red, green, blue, alpha).method_22913(water.method_4577(), water.method_4593() + maxV).method_60803(0xF000F0).method_22922(PACKED_OVERLAY).method_22914(0.0f, 1.0f, 0.0f);
            consumer.method_22918(matrix, 1.0f - sizeFactor, 0.0f, sizeFactor).method_1336(red, green, blue, alpha).method_22913(water.method_4577(), water.method_4593() + minV).method_60803(0xF000F0).method_22922(PACKED_OVERLAY).method_22914(0.0f, 1.0f, 0.0f);
            consumer.method_22918(matrix, sizeFactor, 0.0f, sizeFactor).method_1336(red, green, blue, alpha).method_22913(water.method_4594(), water.method_4593() + minV).method_60803(0xF000F0).method_22922(PACKED_OVERLAY).method_22914(0.0f, 1.0f, 0.0f);
        });
        poseStack.method_22909();
    }
}

