/*
 * Decompiled with CFR 0.152.
 */
package dev.maxoduke.mods.potioncauldron.block;

import dev.maxoduke.mods.potioncauldron.PotionCauldron;
import dev.maxoduke.mods.potioncauldron.block.PotionCauldronBlock;
import dev.maxoduke.mods.potioncauldron.block.PotionCauldronBlockEntity;
import dev.maxoduke.mods.potioncauldron.networking.ServerNetworking;
import dev.maxoduke.mods.potioncauldron.networking.payloads.ParticlePayload;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5328;
import net.minecraft.class_5556;
import net.minecraft.class_5620;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9334;

public class PotionCauldronBlockInteraction {
    public static final class_5620.class_8821 INTERACTION_MAP = class_5620.method_32206((String)"PotionCauldronInteractionMap");
    public static final Map<class_1792, class_5620> MAP = INTERACTION_MAP.comp_1982();

    public static void bootstrap() {
        class_5620.field_27775.comp_1982().put(class_1802.field_8436, PotionCauldronBlockInteraction::fillEmptyCauldronWithPotion);
        class_5620.field_27775.comp_1982().put(class_1802.field_8150, PotionCauldronBlockInteraction::fillEmptyCauldronWithPotion);
        MAP.put(class_1802.field_8574, PotionCauldronBlockInteraction::fillPotionCauldronWithPotion);
        MAP.put(class_1802.field_8436, PotionCauldronBlockInteraction::fillPotionCauldronWithPotion);
        MAP.put(class_1802.field_8150, PotionCauldronBlockInteraction::fillPotionCauldronWithPotion);
        MAP.put(class_1802.field_8705, PotionCauldronBlockInteraction::fillPotionCauldronWithWaterOrLavaBucket);
        MAP.put(class_1802.field_8187, PotionCauldronBlockInteraction::fillPotionCauldronWithWaterOrLavaBucket);
        MAP.put(class_1802.field_8469, PotionCauldronBlockInteraction::fillBottleFromPotionCauldron);
        MAP.put(class_1802.field_8107, PotionCauldronBlockInteraction::createTippedArrowsFromPotionCauldron);
    }

    public static class_1269 fillEmptyCauldronWithPotion(class_2680 ignored, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_1799 itemStack) {
        class_2960 potionTypeResource = class_2960.method_12829((String)itemStack.method_7909().toString());
        class_1844 potionContents = (class_1844)itemStack.method_58694(class_9334.field_49651);
        Optional potionHolder = potionContents.comp_2378();
        if (potionHolder.isEmpty()) {
            return class_1269.field_5811;
        }
        class_6880 potion = (class_6880)potionHolder.get();
        String potionType = potionTypeResource.toString();
        if (potion == class_1847.field_8991 || potion == class_1847.field_8999 || potion == class_1847.field_8967 || potion == class_1847.field_8985) {
            return class_1269.field_5811;
        }
        level.method_8501(blockPos, PotionCauldron.BLOCK.method_9564());
        PotionCauldronBlockEntity blockEntity = (PotionCauldronBlockEntity)level.method_8321(blockPos);
        blockEntity.setPotion((class_6880<class_1842>)potion);
        blockEntity.setPotionType(potionType);
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        OptionalInt particleColor = class_1844.method_58111((Iterable)((class_1842)potion.comp_349()).method_8049());
        if (particleColor.isPresent()) {
            ServerNetworking.sendParticlesToClients(new ParticlePayload(class_2398.field_11226, blockPos, particleColor.getAsInt(), true));
        }
        player.method_6122(interactionHand, class_5328.method_30012((class_1799)itemStack, (class_1657)player, (class_1799)new class_1799((class_1935)class_1802.field_8469)));
        level.method_8396(null, blockPos, class_3417.field_14826, class_3419.field_15245, 1.0f, 1.0f);
        level.method_33596(null, (class_6880)class_5712.field_28166, blockPos);
        return class_1269.field_52422;
    }

    private static class_1269 fillPotionCauldronWithPotion(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_1799 itemStack) {
        class_2960 potionTypeResource = class_2960.method_12829((String)itemStack.method_7909().toString());
        if (potionTypeResource == null) {
            return class_1269.field_5811;
        }
        class_1844 potionContents = (class_1844)itemStack.method_58694(class_9334.field_49651);
        if (potionContents == null) {
            return class_1269.field_5811;
        }
        Optional potionHolder = potionContents.comp_2378();
        if (potionHolder.isEmpty()) {
            return class_1269.field_5811;
        }
        class_6880 potionInHand = (class_6880)potionHolder.get();
        String potionTypeInHand = potionTypeResource.toString();
        if (potionInHand == class_1847.field_8991 || potionInHand == class_1847.field_8999 || potionInHand == class_1847.field_8967 || potionInHand == class_1847.field_8985) {
            return class_1269.field_5811;
        }
        if ((Integer)blockState.method_11654((class_2769)class_5556.field_27206) == 3) {
            return class_1269.field_5811;
        }
        PotionCauldronBlockEntity blockEntity = (PotionCauldronBlockEntity)level.method_8321(blockPos);
        class_6880<class_1842> potionInCauldron = blockEntity.getPotion();
        String potionTypeInCauldron = blockEntity.getPotionType();
        if (potionInCauldron != potionInHand) {
            return PotionCauldronBlockInteraction.handlePotionMixing(level, blockPos, player, interactionHand, itemStack);
        }
        if (!potionTypeInCauldron.equals(potionTypeInHand)) {
            if (!PotionCauldron.CONFIG_MANAGER.clientOrServerConfig().shouldAllowMergingPotions()) {
                return PotionCauldronBlockInteraction.handlePotionMixing(level, blockPos, player, interactionHand, itemStack);
            }
            blockEntity.setPotionType(potionTypeInHand);
        }
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        level.method_8501(blockPos, (class_2680)blockState.method_28493((class_2769)class_5556.field_27206));
        OptionalInt particleColor = class_1844.method_58111((Iterable)((class_1842)potionInCauldron.comp_349()).method_8049());
        if (particleColor.isPresent()) {
            ServerNetworking.sendParticlesToClients(new ParticlePayload(class_2398.field_11226, blockPos, particleColor.getAsInt(), true));
        }
        player.method_6122(interactionHand, class_5328.method_30012((class_1799)itemStack, (class_1657)player, (class_1799)new class_1799((class_1935)class_1802.field_8469)));
        level.method_8396(null, blockPos, class_3417.field_14826, class_3419.field_15245, 1.0f, 1.0f);
        level.method_33596(null, (class_6880)class_5712.field_28166, blockPos);
        return class_1269.field_52422;
    }

    private static class_1269 fillPotionCauldronWithWaterOrLavaBucket(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_1799 itemStack) {
        return PotionCauldronBlockInteraction.handlePotionMixing(level, blockPos, player, interactionHand, itemStack);
    }

    private static class_1269 fillBottleFromPotionCauldron(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_1799 itemStack) {
        Optional potionTypeHolder;
        if ((Integer)blockState.method_11654((class_2769)class_5556.field_27206) == 0) {
            return class_1269.field_5811;
        }
        PotionCauldronBlockEntity blockEntity = (PotionCauldronBlockEntity)level.method_8321(blockPos);
        if (blockEntity == null) {
            return class_1269.field_5811;
        }
        class_6880<class_1842> potion = blockEntity.getPotion();
        if (potion == null) {
            return class_1269.field_5811;
        }
        class_2960 potionTypeResourceLocation = class_2960.method_12829((String)blockEntity.getPotionType());
        if (potionTypeResourceLocation == null) {
            return class_1269.field_5811;
        }
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        OptionalInt particleColor = class_1844.method_58111((Iterable)((class_1842)potion.comp_349()).method_8049());
        if (particleColor.isPresent()) {
            ServerNetworking.sendParticlesToClients(new ParticlePayload(class_2398.field_11226, blockPos, particleColor.getAsInt(), true));
        }
        if ((potionTypeHolder = class_7923.field_41178.method_10223(potionTypeResourceLocation)).isEmpty()) {
            return class_1269.field_5811;
        }
        class_1792 potionType = (class_1792)((class_6880.class_6883)potionTypeHolder.get()).comp_349();
        player.method_6122(interactionHand, class_5328.method_30012((class_1799)itemStack, (class_1657)player, (class_1799)class_1844.method_57400((class_1792)potionType, potion)));
        class_5556.method_31650((class_2680)blockState, (class_1937)level, (class_2338)blockPos);
        level.method_8396(null, blockPos, class_3417.field_14779, class_3419.field_15245, 1.0f, 1.0f);
        level.method_33596(null, (class_6880)class_5712.field_28167, blockPos);
        return class_1269.field_52422;
    }

    private static class_1269 createTippedArrowsFromPotionCauldron(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 ignored, class_1799 stack) {
        class_1661 inventory;
        if (!PotionCauldron.CONFIG_MANAGER.clientOrServerConfig().shouldAllowCreatingTippedArrows()) {
            return class_1269.field_5811;
        }
        if ((Integer)blockState.method_11654((class_2769)class_5556.field_27206) == 0) {
            return class_1269.field_5811;
        }
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        HashMap<Integer, Integer> cauldronLevelToArrows = PotionCauldron.CONFIG_MANAGER.serverConfig().maxTippedArrowsPerLevel();
        int currentCauldronLevel = (Integer)blockState.method_11654((class_2769)class_5556.field_27206);
        int maxTippedArrowCount = cauldronLevelToArrows.get(currentCauldronLevel);
        int tippedArrowCount = Math.min(stack.method_7947(), maxTippedArrowCount);
        int usedCauldronLevels = -1;
        for (Map.Entry<Integer, Integer> item : cauldronLevelToArrows.entrySet()) {
            if (tippedArrowCount > item.getValue()) continue;
            usedCauldronLevels = item.getKey();
            break;
        }
        int remainingCauldronLevels = currentCauldronLevel - usedCauldronLevels;
        PotionCauldronBlockEntity blockEntity = (PotionCauldronBlockEntity)level.method_8321(blockPos);
        class_6880<class_1842> potion = blockEntity.getPotion();
        class_1799 tippedArrows = new class_1799((class_1935)class_1802.field_8087);
        tippedArrows.method_7939(tippedArrowCount);
        tippedArrows.method_57379(class_9334.field_49651, (Object)new class_1844(potion));
        OptionalInt particleColor = class_1844.method_58111((Iterable)((class_1842)potion.comp_349()).method_8049());
        if (particleColor.isPresent()) {
            ServerNetworking.sendParticlesToClients(new ParticlePayload(class_2398.field_11226, blockPos, particleColor.getAsInt(), true));
        }
        level.method_8501(blockPos, remainingCauldronLevels == 0 ? class_2246.field_10593.method_9564() : (class_2680)blockState.method_11657((class_2769)PotionCauldronBlock.field_27206, (Comparable)Integer.valueOf(remainingCauldronLevels)));
        if (!player.method_68878()) {
            stack.method_7934(tippedArrowCount);
        }
        if (!(inventory = player.method_31548()).method_7394(tippedArrows)) {
            player.method_7328(tippedArrows, false);
        }
        level.method_8396(null, blockPos, class_3417.field_14737, class_3419.field_15245, 1.0f, 1.0f);
        level.method_33596(null, (class_6880)class_5712.field_28167, blockPos);
        return class_1269.field_52422;
    }

    private static class_1269 handlePotionMixing(class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_1799 itemStack) {
        if (!PotionCauldron.CONFIG_MANAGER.clientOrServerConfig().shouldEvaporatePotionWhenMixed()) {
            return class_1269.field_5811;
        }
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        ServerNetworking.sendParticlesToClients(new ParticlePayload((class_2396<?>)class_2398.field_11203, blockPos));
        level.method_8501(blockPos, class_2246.field_10593.method_9564());
        class_1799 itemToGiveBack = itemStack.method_7909() == class_1802.field_8705 || itemStack.method_7909() == class_1802.field_8187 ? new class_1799((class_1935)class_1802.field_8550) : new class_1799((class_1935)class_1802.field_8469);
        player.method_6122(interactionHand, class_5328.method_30012((class_1799)itemStack, (class_1657)player, (class_1799)itemToGiveBack));
        level.method_8396(null, blockPos, PotionCauldron.POTION_EVAPORATES_SOUND_EVENT, class_3419.field_15245, 1.0f, 1.0f);
        level.method_33596(null, (class_6880)class_5712.field_28166, blockPos);
        return class_1269.field_52422;
    }
}

