/*
 * Decompiled with CFR 0.152.
 */
package dev.maxoduke.mods.potioncauldron.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dev.maxoduke.mods.potioncauldron.config.ServerConfig;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class ConfigJsonAdapter
implements JsonSerializer<ServerConfig>,
JsonDeserializer<ServerConfig> {
    public JsonElement serialize(ServerConfig config, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject configJson = new JsonObject();
        configJson.addProperty("evaporatePotionWhenMixed", Boolean.valueOf(config.shouldEvaporatePotionWhenMixed()));
        configJson.addProperty("allowMergingPotions", Boolean.valueOf(config.shouldAllowMergingPotions()));
        configJson.addProperty("applyPotionEffectsToEntitiesInside", Boolean.valueOf(config.shouldApplyPotionEffectsToEntitiesInside()));
        configJson.addProperty("allowFillingWithWaterDrips", Boolean.valueOf(config.shouldAllowFillingWithWaterDrips()));
        configJson.addProperty("allowCreatingTippedArrows", Boolean.valueOf(config.shouldAllowCreatingTippedArrows()));
        JsonObject maxTippedArrowsPerLevel = new JsonObject();
        maxTippedArrowsPerLevel.addProperty("level1", (Number)config.getMaxTippedArrowsForLevel1());
        maxTippedArrowsPerLevel.addProperty("level2", (Number)config.getMaxTippedArrowsForLevel2());
        maxTippedArrowsPerLevel.addProperty("level3", (Number)config.getMaxTippedArrowsForLevel3());
        configJson.add("maxTippedArrowsPerLevel", (JsonElement)maxTippedArrowsPerLevel);
        configJson.addProperty("generateInSwampHuts", Boolean.valueOf(config.shouldGenerateInSwampHuts()));
        JsonObject potionTypeChances = new JsonObject();
        potionTypeChances.addProperty("normal", (Number)config.getNormalPotionChance());
        potionTypeChances.addProperty("splash", (Number)config.getSplashPotionChance());
        potionTypeChances.addProperty("lingering", (Number)config.getLingeringPotionChance());
        configJson.add("potionTypeChances", (JsonElement)potionTypeChances);
        JsonObject potionLevelChances = new JsonObject();
        potionLevelChances.addProperty("level1", (Number)config.getLevel1Chance());
        potionLevelChances.addProperty("level2", (Number)config.getLevel2Chance());
        potionLevelChances.addProperty("level3", (Number)config.getLevel3Chance());
        configJson.add("potionLevelChances", (JsonElement)potionLevelChances);
        JsonArray possiblePotions = new JsonArray();
        for (Map.Entry<String, Double> entry : config.potionChances().entrySet()) {
            JsonObject potionWithItsChance = new JsonObject();
            potionWithItsChance.addProperty("name", entry.getKey());
            potionWithItsChance.addProperty("chance", (Number)entry.getValue());
            possiblePotions.add((JsonElement)potionWithItsChance);
        }
        configJson.add("potionChances", (JsonElement)possiblePotions);
        return configJson;
    }

    public ServerConfig deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject configJson = jsonElement.getAsJsonObject();
        ServerConfig config = new ServerConfig();
        config.setEvaporatePotionWhenMixed(configJson.get("evaporatePotionWhenMixed").getAsBoolean());
        config.setAllowMergingPotions(configJson.get("allowMergingPotions").getAsBoolean());
        config.setApplyPotionEffectsToEntitiesInside(configJson.get("applyPotionEffectsToEntitiesInside").getAsBoolean());
        config.setAllowFillingWithWaterDrips(configJson.get("allowFillingWithWaterDrips").getAsBoolean());
        config.setAllowCreatingTippedArrows(configJson.get("allowCreatingTippedArrows").getAsBoolean());
        JsonObject maxTippedArrowsPerLevel = configJson.getAsJsonObject("maxTippedArrowsPerLevel");
        config.setMaxTippedArrowsForLevel1(maxTippedArrowsPerLevel.get("level1").getAsInt());
        config.setMaxTippedArrowsForLevel2(maxTippedArrowsPerLevel.get("level2").getAsInt());
        config.setMaxTippedArrowsForLevel3(maxTippedArrowsPerLevel.get("level3").getAsInt());
        config.setGenerateInSwampHuts(configJson.get("generateInSwampHuts").getAsBoolean());
        JsonObject potionTypeChances = configJson.getAsJsonObject("potionTypeChances");
        config.setNormalPotionChance(potionTypeChances.get("normal").getAsDouble());
        config.setSplashPotionChance(potionTypeChances.get("splash").getAsDouble());
        config.setLingeringPotionChance(potionTypeChances.get("lingering").getAsDouble());
        JsonObject potionLevelChances = configJson.getAsJsonObject("potionLevelChances");
        config.setLevel1Chance(potionLevelChances.get("level1").getAsDouble());
        config.setLevel2Chance(potionLevelChances.get("level2").getAsDouble());
        config.setLevel3Chance(potionLevelChances.get("level3").getAsDouble());
        HashMap<String, Double> potions = config.potionChances();
        JsonArray possiblePotions = configJson.getAsJsonArray("potionChances");
        for (JsonElement json : possiblePotions) {
            JsonObject possiblePotionJson = json.getAsJsonObject();
            String potionName = possiblePotionJson.get("name").getAsString();
            double chance = possiblePotionJson.get("chance").getAsDouble();
            potions.put(potionName, chance);
        }
        return config;
    }
}

