/*
 * Decompiled with CFR 0.152.
 */
package dev.maxoduke.mods.potioncauldron.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import dev.maxoduke.mods.potioncauldron.PotionCauldron;
import dev.maxoduke.mods.potioncauldron.config.ConfigJsonAdapter;
import dev.maxoduke.mods.potioncauldron.config.IConfig;
import dev.maxoduke.mods.potioncauldron.config.exceptions.ConfigNotFoundException;
import dev.maxoduke.mods.potioncauldron.config.exceptions.InvalidConfigException;
import dev.maxoduke.mods.potioncauldron.networking.payloads.ClientConfigPayload;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;

public class ServerConfig
implements IConfig {
    public static final String CONFIG_FILE_NAME = "potion-cauldron.json";
    public static final Path CONFIG_FILE_PATH = Path.of(FabricLoader.getInstance().getConfigDir().toString(), CONFIG_FILE_NAME);
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(ServerConfig.class, (Object)new ConfigJsonAdapter()).setPrettyPrinting().create();
    private boolean evaporatePotionWhenMixed;
    private boolean allowMergingPotions;
    private boolean applyPotionEffectsToEntitiesInside;
    private boolean allowFillingWithWaterDrips;
    private boolean allowCreatingTippedArrows;
    private int maxTippedArrowsForLevel1;
    private int maxTippedArrowsForLevel2;
    private int maxTippedArrowsForLevel3;
    private boolean generateInSwampHuts;
    private double normalPotionChance;
    private double splashPotionChance;
    private double lingeringPotionChance;
    private double level1Chance;
    private double level2Chance;
    private double level3Chance;
    private final HashMap<String, Double> _potionChances = new HashMap();

    @NotNull
    public ClientConfigPayload asClientConfig() {
        return new ClientConfigPayload(this.evaporatePotionWhenMixed, this.allowMergingPotions, this.allowCreatingTippedArrows);
    }

    @Override
    public boolean shouldEvaporatePotionWhenMixed() {
        return this.evaporatePotionWhenMixed;
    }

    public void setEvaporatePotionWhenMixed(boolean evaporatePotionWhenMixed) {
        this.evaporatePotionWhenMixed = evaporatePotionWhenMixed;
    }

    @Override
    public boolean shouldAllowMergingPotions() {
        return this.allowMergingPotions;
    }

    public void setAllowMergingPotions(boolean allowMergingPotions) {
        this.allowMergingPotions = allowMergingPotions;
    }

    public boolean shouldApplyPotionEffectsToEntitiesInside() {
        return this.applyPotionEffectsToEntitiesInside;
    }

    public void setApplyPotionEffectsToEntitiesInside(boolean value) {
        this.applyPotionEffectsToEntitiesInside = value;
    }

    public boolean shouldAllowFillingWithWaterDrips() {
        return this.allowFillingWithWaterDrips;
    }

    public void setAllowFillingWithWaterDrips(boolean value) {
        this.allowFillingWithWaterDrips = value;
    }

    @Override
    public boolean shouldAllowCreatingTippedArrows() {
        return this.allowCreatingTippedArrows;
    }

    public void setAllowCreatingTippedArrows(boolean allowCreatingTippedArrows) {
        this.allowCreatingTippedArrows = allowCreatingTippedArrows;
    }

    public int getMaxTippedArrowsForLevel1() {
        return this.maxTippedArrowsForLevel1;
    }

    public void setMaxTippedArrowsForLevel1(int maxTippedArrowsForLevel1) {
        this.maxTippedArrowsForLevel1 = maxTippedArrowsForLevel1;
    }

    public int getMaxTippedArrowsForLevel2() {
        return this.maxTippedArrowsForLevel2;
    }

    public void setMaxTippedArrowsForLevel2(int maxTippedArrowsForLevel2) {
        this.maxTippedArrowsForLevel2 = maxTippedArrowsForLevel2;
    }

    public int getMaxTippedArrowsForLevel3() {
        return this.maxTippedArrowsForLevel3;
    }

    public void setMaxTippedArrowsForLevel3(int maxTippedArrowsForLevel3) {
        this.maxTippedArrowsForLevel3 = maxTippedArrowsForLevel3;
    }

    public boolean shouldGenerateInSwampHuts() {
        return this.generateInSwampHuts;
    }

    public void setGenerateInSwampHuts(boolean value) {
        this.generateInSwampHuts = value;
    }

    public double getNormalPotionChance() {
        return this.normalPotionChance;
    }

    public void setNormalPotionChance(double normalPotionChance) {
        this.normalPotionChance = normalPotionChance;
    }

    public double getSplashPotionChance() {
        return this.splashPotionChance;
    }

    public void setSplashPotionChance(double splashPotionChance) {
        this.splashPotionChance = splashPotionChance;
    }

    public double getLingeringPotionChance() {
        return this.lingeringPotionChance;
    }

    public void setLingeringPotionChance(double lingeringPotionChance) {
        this.lingeringPotionChance = lingeringPotionChance;
    }

    public double getLevel1Chance() {
        return this.level1Chance;
    }

    public void setLevel1Chance(double level1Chance) {
        this.level1Chance = level1Chance;
    }

    public double getLevel2Chance() {
        return this.level2Chance;
    }

    public void setLevel2Chance(double level2Chance) {
        this.level2Chance = level2Chance;
    }

    public double getLevel3Chance() {
        return this.level3Chance;
    }

    public void setLevel3Chance(double level3Chance) {
        this.level3Chance = level3Chance;
    }

    public HashMap<Integer, Integer> maxTippedArrowsPerLevel() {
        HashMap<Integer, Integer> maxTippedArrowsPerLevel = new HashMap<Integer, Integer>();
        maxTippedArrowsPerLevel.put(1, this.maxTippedArrowsForLevel1);
        maxTippedArrowsPerLevel.put(2, this.maxTippedArrowsForLevel2);
        maxTippedArrowsPerLevel.put(3, this.maxTippedArrowsForLevel3);
        return maxTippedArrowsPerLevel;
    }

    public HashMap<String, Double> potionTypeChances() {
        HashMap<String, Double> possiblePotionTypes = new HashMap<String, Double>();
        possiblePotionTypes.put("minecraft:potion", this.normalPotionChance);
        possiblePotionTypes.put("minecraft:splash_potion", this.splashPotionChance);
        possiblePotionTypes.put("minecraft:lingering_potion", this.lingeringPotionChance);
        return possiblePotionTypes;
    }

    public HashMap<Integer, Double> potionLevelChances() {
        HashMap<Integer, Double> possiblePotionLevels = new HashMap<Integer, Double>();
        possiblePotionLevels.put(1, this.level1Chance);
        possiblePotionLevels.put(2, this.level2Chance);
        possiblePotionLevels.put(3, this.level3Chance);
        return possiblePotionLevels;
    }

    public HashMap<String, Double> potionChances() {
        return this._potionChances;
    }

    private double validateAndGetTotalChance(Collection<Double> values, boolean allowZeroIndividualChance) {
        BigDecimal totalBD = BigDecimal.valueOf(0.0);
        for (double chance : values) {
            if (chance < 0.0 || !allowZeroIndividualChance && chance == 0.0 || chance > 1.0) {
                throw new InvalidConfigException();
            }
            totalBD = totalBD.add(BigDecimal.valueOf(chance));
        }
        double total = totalBD.doubleValue();
        if (total < 0.0 || total > 1.0) {
            throw new InvalidConfigException();
        }
        return total;
    }

    public void throwIfInvalid() {
        this.validateAndGetTotalChance(this.potionChances().values(), false);
        double totalPotionTypeChance = this.validateAndGetTotalChance(this.potionTypeChances().values(), true);
        double totalPotionLevelChance = this.validateAndGetTotalChance(this.potionLevelChances().values(), true);
        if (totalPotionTypeChance != 1.0 || totalPotionLevelChance != 1.0) {
            throw new InvalidConfigException();
        }
        if (this.maxTippedArrowsForLevel1 >= this.maxTippedArrowsForLevel2 || this.maxTippedArrowsForLevel2 >= this.maxTippedArrowsForLevel3) {
            throw new InvalidConfigException();
        }
    }

    public boolean notEquals(ServerConfig that) {
        return this.evaporatePotionWhenMixed != that.evaporatePotionWhenMixed || this.allowMergingPotions != that.allowMergingPotions || this.applyPotionEffectsToEntitiesInside != that.applyPotionEffectsToEntitiesInside || this.allowFillingWithWaterDrips != that.allowFillingWithWaterDrips || this.allowCreatingTippedArrows != that.allowCreatingTippedArrows || this.maxTippedArrowsForLevel1 != that.maxTippedArrowsForLevel1 || this.maxTippedArrowsForLevel2 != that.maxTippedArrowsForLevel2 || this.maxTippedArrowsForLevel3 != that.maxTippedArrowsForLevel3 || this.generateInSwampHuts != that.generateInSwampHuts || this.normalPotionChance != that.normalPotionChance || this.splashPotionChance != that.splashPotionChance || this.lingeringPotionChance != that.lingeringPotionChance || this.level1Chance != that.level1Chance || this.level2Chance != that.level2Chance || this.level3Chance != that.level3Chance || !this._potionChances.equals(that._potionChances);
    }

    public ServerConfig copy() {
        ServerConfig copy = new ServerConfig();
        copy.evaporatePotionWhenMixed = this.evaporatePotionWhenMixed;
        copy.allowMergingPotions = this.allowMergingPotions;
        copy.applyPotionEffectsToEntitiesInside = this.applyPotionEffectsToEntitiesInside;
        copy.allowFillingWithWaterDrips = this.allowFillingWithWaterDrips;
        copy.allowCreatingTippedArrows = this.allowCreatingTippedArrows;
        copy.maxTippedArrowsForLevel1 = this.maxTippedArrowsForLevel1;
        copy.maxTippedArrowsForLevel2 = this.maxTippedArrowsForLevel2;
        copy.maxTippedArrowsForLevel3 = this.maxTippedArrowsForLevel3;
        copy.generateInSwampHuts = this.generateInSwampHuts;
        copy.normalPotionChance = this.normalPotionChance;
        copy.splashPotionChance = this.splashPotionChance;
        copy.lingeringPotionChance = this.lingeringPotionChance;
        copy.level1Chance = this.level1Chance;
        copy.level2Chance = this.level2Chance;
        copy.level3Chance = this.level3Chance;
        copy._potionChances.putAll(this._potionChances);
        return copy;
    }

    public void save() {
        try {
            String jsonData = GSON.toJson((Object)this, ServerConfig.class);
            Files.writeString(CONFIG_FILE_PATH, (CharSequence)jsonData, new OpenOption[0]);
        }
        catch (Exception ex) {
            PotionCauldron.LOG.error("Error saving Potion Cauldron config: {}", (Object)ex.getMessage());
        }
    }

    @NotNull
    public static ServerConfig load() {
        try {
            if (!Files.exists(CONFIG_FILE_PATH, new LinkOption[0])) {
                throw new ConfigNotFoundException();
            }
            String jsonData = Files.readString(CONFIG_FILE_PATH);
            ServerConfig loadedConfig = (ServerConfig)GSON.fromJson(jsonData, ServerConfig.class);
            if (loadedConfig == null) {
                throw new InvalidConfigException();
            }
            loadedConfig.throwIfInvalid();
            return loadedConfig;
        }
        catch (Exception ex) {
            PotionCauldron.LOG.error(ex instanceof NullPointerException || ex instanceof JsonParseException ? new InvalidConfigException().getMessage() : ex.getMessage());
            ServerConfig config = ServerConfig.createDefault();
            config.save();
            return config;
        }
    }

    public static ServerConfig createDefault() {
        ServerConfig config = new ServerConfig();
        config.evaporatePotionWhenMixed = true;
        config.allowMergingPotions = true;
        config.applyPotionEffectsToEntitiesInside = false;
        config.allowCreatingTippedArrows = true;
        config.maxTippedArrowsForLevel1 = 16;
        config.maxTippedArrowsForLevel2 = 32;
        config.maxTippedArrowsForLevel3 = 64;
        config.generateInSwampHuts = true;
        config.normalPotionChance = 0.75;
        config.splashPotionChance = 0.25;
        config.lingeringPotionChance = 0.0;
        config.level1Chance = 0.5;
        config.level2Chance = 0.3;
        config.level3Chance = 0.2;
        config._potionChances.put("minecraft:fire_resistance", 0.05);
        config._potionChances.put("minecraft:slowness", 0.1);
        config._potionChances.put("minecraft:weakness", 0.1);
        config._potionChances.put("minecraft:strength", 0.1);
        config._potionChances.put("minecraft:water_breathing", 0.1);
        config._potionChances.put("minecraft:swiftness", 0.15);
        config._potionChances.put("minecraft:healing", 0.2);
        config._potionChances.put("minecraft:poison", 0.2);
        return config;
    }
}

