/*
 * Decompiled with CFR 0.152.
 */
package dev.maxoduke.mods.potioncauldron;

import com.mojang.brigadier.CommandDispatcher;
import dev.maxoduke.mods.potioncauldron.block.CauldronInteractionInjector;
import dev.maxoduke.mods.potioncauldron.block.PotionCauldronBlock;
import dev.maxoduke.mods.potioncauldron.block.PotionCauldronBlockEntity;
import dev.maxoduke.mods.potioncauldron.block.PotionCauldronBlockEntityRenderer;
import dev.maxoduke.mods.potioncauldron.block.PotionCauldronBlockInteraction;
import dev.maxoduke.mods.potioncauldron.commands.CommandHandlers;
import dev.maxoduke.mods.potioncauldron.config.ConfigManager;
import dev.maxoduke.mods.potioncauldron.config.gui.ConfigScreen;
import dev.maxoduke.mods.potioncauldron.networking.ClientNetworking;
import dev.maxoduke.mods.potioncauldron.networking.NetworkHandler;
import dev.maxoduke.mods.potioncauldron.networking.ServerNetworking;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="potioncauldron")
public class PotionCauldron {
    private static FMLJavaModLoadingContext context;
    public static final String MOD_ID = "potioncauldron";
    public static final String MOD_NAME = "Potion Cauldron";
    public static final Logger LOG;
    public static final String BLOCK_NAME = "potion_cauldron";
    public static final String BLOCK_ENTITY_NAME = "potion_cauldron_block_entity";
    public static final String POTION_EVAPORATES_SOUND_NAME = "potion_evaporates";
    public static final ResourceLocation POTION_EVAPORATES_SOUND_ID;
    public static final ResourceLocation CONFIG_CHANNEL;
    public static final ResourceLocation PARTICLES_CHANNEL;
    private static final DeferredRegister<Block> BLOCKS;
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES;
    private static final DeferredRegister<SoundEvent> SOUND_EVENTS;
    public static final RegistryObject<PotionCauldronBlock> BLOCK;
    public static final RegistryObject<BlockEntityType<PotionCauldronBlockEntity>> BLOCK_ENTITY;
    public static final RegistryObject<SoundEvent> POTION_EVAPORATES_SOUND_EVENT;
    public static final ConfigManager CONFIG_MANAGER;

    public PotionCauldron(FMLJavaModLoadingContext context) {
        PotionCauldron.context = context;
        CauldronInteractionInjector.injectIntoEmptyPotionInteraction();
        PotionCauldronBlockInteraction.bootstrap();
        NetworkHandler.register();
        BusGroup modBusGroup = context.getModBusGroup();
        BLOCKS.register(modBusGroup);
        BLOCK_ENTITIES.register(modBusGroup);
        SOUND_EVENTS.register(modBusGroup);
        EntityRenderersEvent.RegisterRenderers.BUS.addListener(this::registerBlockEntityRenderers);
        RegisterCommandsEvent.BUS.addListener(this::registerCommands);
        ServerStartingEvent.BUS.addListener(this::serverStarting);
        ServerStoppingEvent.BUS.addListener(this::serverStopping);
        PlayerEvent.PlayerLoggedInEvent.BUS.addListener(this::playerJoined);
    }

    @SubscribeEvent
    public void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)BLOCK_ENTITY.get(), PotionCauldronBlockEntityRenderer::new);
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        CommandHandlers.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
    }

    @SubscribeEvent
    public void serverStarting(ServerStartingEvent event) {
        ServerNetworking.serverStarting(event.getServer());
    }

    @SubscribeEvent
    public void serverStopping(ServerStoppingEvent event) {
        ServerNetworking.serverStopping();
    }

    @SubscribeEvent
    public void playerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        ServerNetworking.sendConfigToClient(player);
    }

    static {
        LOG = LogManager.getLogger((String)MOD_NAME);
        POTION_EVAPORATES_SOUND_ID = ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)POTION_EVAPORATES_SOUND_NAME);
        CONFIG_CHANNEL = ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"config_channel");
        PARTICLES_CHANNEL = ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"particles_channel");
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)MOD_ID);
        BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)MOD_ID);
        SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)MOD_ID);
        BLOCK = BLOCKS.register(BLOCK_NAME, () -> new PotionCauldronBlock(PotionCauldronBlockInteraction.INTERACTION_MAP, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)BLOCK_NAME)))));
        BLOCK_ENTITY = BLOCK_ENTITIES.register(BLOCK_ENTITY_NAME, () -> new BlockEntityType(PotionCauldronBlockEntity::new, Set.of((Block)BLOCK.get())));
        POTION_EVAPORATES_SOUND_EVENT = SOUND_EVENTS.register(POTION_EVAPORATES_SOUND_NAME, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)POTION_EVAPORATES_SOUND_ID));
        CONFIG_MANAGER = new ConfigManager();
    }

    @Mod.EventBusSubscriber(modid="potioncauldron", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ClientModNetworkEvents {
        @SubscribeEvent
        public static void clientDisconnected(ClientPlayerNetworkEvent.LoggingOut event) {
            ClientNetworking.clientDisconnected();
        }
    }

    @Mod.EventBusSubscriber(modid="potioncauldron", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            context.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> ConfigScreen.create(screen)));
        }
    }
}

