/*
 * Decompiled with CFR 0.152.
 */
package dev.maxoduke.mods.potioncauldron.block;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.maxoduke.mods.potioncauldron.block.PotionCauldronBlock;
import dev.maxoduke.mods.potioncauldron.block.PotionCauldronBlockEntity;
import dev.maxoduke.mods.potioncauldron.block.PotionCauldronBlockEntityRenderState;
import java.util.OptionalInt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class PotionCauldronBlockEntityRenderer
implements BlockEntityRenderer<PotionCauldronBlockEntity, PotionCauldronBlockEntityRenderState> {
    private static final float[] FLUID_HEIGHT = new float[]{0.0f, 0.5625f, 0.75f, 0.9375f};
    private static final Material WATER_MATERIAL = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace((String)"block/water_still"));
    private static final RenderType POTION_CAULDRON_BLOCK_RENDER_TYPE = RenderType.entityTranslucent((ResourceLocation)TextureAtlas.LOCATION_BLOCKS);

    public PotionCauldronBlockEntityRenderer(BlockEntityRendererProvider.Context ignored) {
    }

    @NotNull
    public PotionCauldronBlockEntityRenderState createRenderState() {
        return new PotionCauldronBlockEntityRenderState();
    }

    public void extractRenderState(PotionCauldronBlockEntity blockEntity, PotionCauldronBlockEntityRenderState blockEntityRenderState, float f, Vec3 vec3, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)blockEntityRenderState, f, vec3, crumblingOverlay);
        int liquidLevel = (Integer)blockEntity.getBlockState().getValue((Property)PotionCauldronBlock.LEVEL);
        if (liquidLevel == 0) {
            return;
        }
        Holder<Potion> potion = blockEntity.getPotion();
        if (potion == null) {
            return;
        }
        OptionalInt spriteColor = PotionContents.getColorOptional((Iterable)((Potion)potion.value()).getEffects());
        if (spriteColor.isEmpty()) {
            return;
        }
        blockEntityRenderState.setLiquidLevel(liquidLevel);
        blockEntityRenderState.setPotion(potion);
        blockEntityRenderState.setSpriteColor(spriteColor.getAsInt());
    }

    public void submit(PotionCauldronBlockEntityRenderState blockEntityRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        int liquidLevel = blockEntityRenderState.getLiquidLevel();
        Holder<Potion> potion = blockEntityRenderState.getPotion();
        int spriteColor = blockEntityRenderState.getSpriteColor();
        if (liquidLevel == 0 || potion == null || spriteColor == 0) {
            return;
        }
        int red = spriteColor >> 16 & 0xFF;
        int green = spriteColor >> 8 & 0xFF;
        int blue = spriteColor & 0xFF;
        int alpha = 190;
        TextureAtlasSprite water = Minecraft.getInstance().getAtlasManager().get(WATER_MATERIAL);
        poseStack.pushPose();
        poseStack.translate(0.0f, FLUID_HEIGHT[liquidLevel] + 0.001f, 0.0f);
        float sizeFactor = 0.125f;
        float maxV = (water.getV1() - water.getV0()) * sizeFactor;
        float minV = (water.getV1() - water.getV0()) * (1.0f - sizeFactor);
        int PACKED_LIGHT = 0xF000F0;
        int PACKED_OVERLAY = OverlayTexture.NO_OVERLAY;
        submitNodeCollector.submitCustomGeometry(poseStack, POTION_CAULDRON_BLOCK_RENDER_TYPE, (pose, consumer) -> {
            Matrix4f matrix = pose.pose();
            consumer.addVertex(matrix, sizeFactor, 0.0f, 1.0f - sizeFactor).setColor(red, green, blue, alpha).setUv(water.getU0(), water.getV0() + maxV).setLight(0xF000F0).setOverlay(PACKED_OVERLAY).setNormal(0.0f, 1.0f, 0.0f);
            consumer.addVertex(matrix, 1.0f - sizeFactor, 0.0f, 1.0f - sizeFactor).setColor(red, green, blue, alpha).setUv(water.getU1(), water.getV0() + maxV).setLight(0xF000F0).setOverlay(PACKED_OVERLAY).setNormal(0.0f, 1.0f, 0.0f);
            consumer.addVertex(matrix, 1.0f - sizeFactor, 0.0f, sizeFactor).setColor(red, green, blue, alpha).setUv(water.getU1(), water.getV0() + minV).setLight(0xF000F0).setOverlay(PACKED_OVERLAY).setNormal(0.0f, 1.0f, 0.0f);
            consumer.addVertex(matrix, sizeFactor, 0.0f, sizeFactor).setColor(red, green, blue, alpha).setUv(water.getU0(), water.getV0() + minV).setLight(0xF000F0).setOverlay(PACKED_OVERLAY).setNormal(0.0f, 1.0f, 0.0f);
        });
        poseStack.popPose();
    }
}

