/*
 * Decompiled with CFR 0.152.
 */
package dev.maxoduke.mods.potioncauldron.config.gui;

import dev.maxoduke.mods.potioncauldron.PotionCauldron;
import dev.maxoduke.mods.potioncauldron.config.ServerConfig;
import dev.maxoduke.mods.potioncauldron.config.gui.ConfigList;
import dev.maxoduke.mods.potioncauldron.networking.ServerNetworking;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public class ConfigScreen
extends Screen {
    private static final Component TITLE = Component.translatable((String)"config.title");
    private static final Component NOTICE_ICON = Component.literal((String)"(?)").withStyle(Style.EMPTY.applyFormat(ChatFormatting.UNDERLINE));
    private static final Component NOTICE_TOOLTIP = Component.translatable((String)"config.notice.tooltip");
    private static final Component SAVE = Component.translatable((String)"config.text.save");
    private static final Component RESET = Component.translatable((String)"config.text.reset");
    private static final Component CANCEL = Component.translatable((String)"config.text.cancel");
    private final Screen parent;
    private final ServerConfig currentConfig;
    private final ServerConfig configToChange;
    private StringWidget noticeIcon;
    private ConfigList configList;
    private Button saveButton;
    private Button resetButton;
    private Button cancelButton;

    private ConfigScreen(Screen parent, ServerConfig currentConfig, ServerConfig configToChange) {
        super(TITLE);
        this.parent = parent;
        this.currentConfig = currentConfig;
        this.configToChange = configToChange;
    }

    protected void init() {
        super.init();
        this.noticeIcon = new StringWidget(this.width - 30, 18, 20, 10, NOTICE_ICON, this.font);
        this.noticeIcon.setTooltip(Tooltip.create((Component)NOTICE_TOOLTIP));
        this.configList = new ConfigList(this, this.font, this.configToChange, this::updateButtonStates);
        this.saveButton = Button.builder((Component)SAVE, this::saveButtonClicked).size(100, 20).pos(this.width / 2 - 160, this.height - 35).build();
        this.resetButton = Button.builder((Component)RESET, this::resetButtonClicked).size(100, 20).pos(this.width / 2 - 50, this.height - 35).build();
        this.cancelButton = Button.builder((Component)CANCEL, this::cancelButtonClicked).size(100, 20).pos(this.width / 2 + 60, this.height - 35).build();
        this.addWidget((GuiEventListener)this.noticeIcon);
        this.addWidget((GuiEventListener)this.configList);
        this.addWidget((GuiEventListener)this.saveButton);
        this.addWidget((GuiEventListener)this.resetButton);
        this.addWidget((GuiEventListener)this.cancelButton);
        this.updateButtonStates();
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawCenteredString(this.font, TITLE, this.width / 2, 20, 0xFFFFFF);
        this.noticeIcon.render(graphics, mouseX, mouseY, partialTick);
        this.configList.render(graphics, mouseX, mouseY, partialTick);
        this.saveButton.render(graphics, mouseX, mouseY, partialTick);
        this.resetButton.render(graphics, mouseX, mouseY, partialTick);
        this.cancelButton.render(graphics, mouseX, mouseY, partialTick);
    }

    private void saveButtonClicked(Button ignored) {
        this.configToChange.save();
        if (PotionCauldron.CONFIG_MANAGER.updateServerConfig(this.configToChange)) {
            ServerNetworking.sendConfigToAllClients();
        }
        Minecraft.getInstance().setScreen(this.parent);
    }

    private void resetButtonClicked(Button ignored) {
        Minecraft.getInstance().setScreen((Screen)ConfigScreen.reset(this.parent));
    }

    private void cancelButtonClicked(Button ignored) {
        Minecraft.getInstance().setScreen(this.parent);
    }

    private void updateButtonStates() {
        this.saveButton.active = this.configToChange.notEquals(this.currentConfig) && this.configList.isValid();
        this.resetButton.active = this.configToChange.notEquals(ServerConfig.createDefault());
    }

    @NotNull
    public static ConfigScreen create(Screen parent) {
        ServerConfig currentConfig = ServerConfig.load();
        ServerConfig configToChange = currentConfig.copy();
        return new ConfigScreen(parent, currentConfig, configToChange);
    }

    @NotNull
    public static ConfigScreen reset(Screen parent) {
        ServerConfig currentConfig = ServerConfig.load();
        ServerConfig configToChange = ServerConfig.createDefault();
        return new ConfigScreen(parent, currentConfig, configToChange);
    }
}

