/*
 * Decompiled with CFR 0.152.
 */
package dev.maxoduke.mods.potioncauldron.config.gui.entries;

import dev.maxoduke.mods.potioncauldron.config.gui.ConfigList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class AddPotionEntry
extends ConfigList.Entry {
    private static final Component ADD = Component.translatable((String)"config.text.add");
    private static final Component ADD_SIGN = Component.literal((String)"+");
    private boolean hasError;
    private final int leftIndent;
    private final StringWidget errorIcon;
    private final EditBox potionNameEdit;
    private final EditBox potionChanceEdit;
    private final Button addButton;

    public AddPotionEntry(Font font, int leftIndent, Consumer<String> onChange, Button.OnPress onClick) {
        this.potionNameEdit = new EditBox(font, 0, 0, 180, 20, EMPTY);
        this.potionChanceEdit = new EditBox(font, 0, 0, 40, 20, EMPTY);
        this.potionNameEdit.setResponder(onChange);
        this.potionChanceEdit.setResponder(onChange);
        this.addButton = Button.builder((Component)ADD_SIGN, (Button.OnPress)onClick).tooltip(Tooltip.create((Component)ADD)).size(30, 24).build();
        this.addButton.active = false;
        this.hasError = false;
        this.errorIcon = new StringWidget(ERROR_ICON, font);
        this.leftIndent = leftIndent;
    }

    public void renderContent(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, boolean bl, float partialTick) {
        int left = super.getX();
        int top = super.getY();
        this.potionNameEdit.setX(left + this.leftIndent);
        this.potionNameEdit.setY(top);
        this.potionNameEdit.render(guiGraphics, mouseX, mouseY, partialTick);
        this.potionChanceEdit.setX(left + 185 + this.leftIndent);
        this.potionChanceEdit.setY(top);
        this.potionChanceEdit.render(guiGraphics, mouseX, mouseY, partialTick);
        this.addButton.setX(left + 228 + this.leftIndent);
        this.addButton.setY(top - 2);
        this.addButton.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.hasError) {
            this.errorIcon.setX(left + 265 + this.leftIndent);
            this.errorIcon.setY(top + 5);
            this.errorIcon.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @NotNull
    public List<? extends NarratableEntry> narratables() {
        return Collections.emptyList();
    }

    @NotNull
    public List<? extends GuiEventListener> children() {
        return List.of(this.potionNameEdit, this.potionChanceEdit, this.addButton, this.errorIcon);
    }

    public String getPotionName() {
        return this.potionNameEdit.getValue().trim();
    }

    public Double getPotionChance() {
        String value = this.potionChanceEdit.getValue().trim();
        if (value.isEmpty()) {
            return null;
        }
        return Double.parseDouble(value) / 100.0;
    }

    public void setError(String errorText) {
        this.hasError = true;
        this.errorIcon.setTooltip(Tooltip.create((Component)Component.literal((String)errorText)));
        this.addButton.active = false;
    }

    public void clearError() {
        this.hasError = false;
        this.errorIcon.setTooltip(null);
        this.addButton.active = true;
    }

    public void disableAddButton() {
        this.addButton.active = false;
    }

    public void clear() {
        this.potionNameEdit.setValue("");
        this.potionChanceEdit.setValue("");
        this.addButton.active = false;
    }
}

