/*
 * Decompiled with CFR 0.152.
 */
package dev.maxoduke.mods.potioncauldron.config.gui.entries;

import dev.maxoduke.mods.potioncauldron.config.gui.ConfigList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class LabelEntry
extends ConfigList.Entry {
    private boolean hasError;
    private final int leftIndent;
    private final StringWidget errorIcon;
    private final StringWidget label;

    public LabelEntry(Font font, Component component, int leftIndent) {
        this.leftIndent = leftIndent;
        this.label = new StringWidget(0, 0, 300, 20, component, font);
        this.hasError = false;
        this.errorIcon = new StringWidget(ERROR_ICON, font);
    }

    public void renderContent(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, boolean bl, float partialTick) {
        int left = super.getX();
        int top = super.getY();
        this.label.setX(left + this.leftIndent);
        this.label.setY(top);
        this.label.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.hasError) {
            this.errorIcon.setX(left + 306);
            this.errorIcon.setY(top + 5);
            this.errorIcon.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @NotNull
    public List<? extends GuiEventListener> children() {
        return Collections.emptyList();
    }

    @NotNull
    public List<? extends NarratableEntry> narratables() {
        return Collections.emptyList();
    }

    public boolean isValid() {
        return !this.hasError;
    }

    public void setError(String errorText) {
        this.hasError = true;
        this.errorIcon.setTooltip(Tooltip.create((Component)Component.literal((String)errorText)));
    }

    public void clearError() {
        this.hasError = false;
        this.errorIcon.setTooltip(null);
    }
}

