/*
 * Decompiled with CFR 0.152.
 */
package mod.fishydish.WalkingHorse;

import java.util.UUID;
import mod.fishydish.WalkingHorse.WalkingHorseConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod(value="walkinghorse")
public class WalkingHorse {
    private static final UUID WALK_MODIFIER_UUID = UUID.fromString("a8b5c3d2-1e4f-5a6b-7c8d-9e0f1a2b3c4d");
    private static final UUID SPRINT_MODIFIER_UUID = UUID.fromString("b9c6d4e3-2f5a-6b7c-8d9e-0f1a2b3c4d5e");

    public WalkingHorse() {
        WalkingHorseConfig.register();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (player.m_20202_() instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)player.m_20202_();
            AttributeInstance speedAttribute = horse.m_21051_(Attributes.f_22279_);
            if (speedAttribute == null) {
                return;
            }
            boolean hasWalkModifier = speedAttribute.m_22111_(WALK_MODIFIER_UUID) != null;
            boolean hasSprintModifier = speedAttribute.m_22111_(SPRINT_MODIFIER_UUID) != null;
            boolean isSprinting = mc.f_91066_.f_92091_.m_90857_();
            if (isSprinting) {
                if (hasWalkModifier) {
                    speedAttribute.m_22120_(WALK_MODIFIER_UUID);
                }
                if (!hasSprintModifier) {
                    AttributeModifier sprintModifier = new AttributeModifier(SPRINT_MODIFIER_UUID, "Horse sprint boost", WalkingHorseConfig.getSprintSpeedModifier(), AttributeModifier.Operation.MULTIPLY_BASE);
                    speedAttribute.m_22118_(sprintModifier);
                }
            } else {
                if (hasSprintModifier) {
                    speedAttribute.m_22120_(SPRINT_MODIFIER_UUID);
                }
                if (!hasWalkModifier) {
                    AttributeModifier walkModifier = new AttributeModifier(WALK_MODIFIER_UUID, "Horse walk slowdown", WalkingHorseConfig.getWalkSpeedModifier(), AttributeModifier.Operation.MULTIPLY_BASE);
                    speedAttribute.m_22118_(walkModifier);
                }
            }
        }
    }
}

