/*
 * Decompiled with CFR 0.152.
 */
package mod.fishydish.WalkingHorse;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class WalkingHorseConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.DoubleValue WALK_SPEED_DECREASE;
    public static final ForgeConfigSpec.DoubleValue SPRINT_SPEED_BOOST;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC, "walkinghorse-common.toml");
    }

    public static double getWalkSpeedModifier() {
        return -((Double)WALK_SPEED_DECREASE.get()).doubleValue();
    }

    public static double getSprintSpeedModifier() {
        return (Double)SPRINT_SPEED_BOOST.get();
    }

    static {
        BUILDER.push("Horse Speed Settings");
        WALK_SPEED_DECREASE = BUILDER.comment("How much to decrease horse walking speed (higher value = slower walk)").comment("Value is a multiplier decrease. Example: 0.7 = 70% slower").comment("Range: 0.0 (no decrease) to 1.0 (100% decrease, horse won't move)").defineInRange("walkSpeedDecrease", 0.7, 0.0, 1.0);
        SPRINT_SPEED_BOOST = BUILDER.comment("Speed boost when sprinting (added to base speed)").comment("Value is a multiplier boost. Example: 0.3 = 30% faster").comment("Set to 0.0 for default horse speed when sprinting").comment("Range: 0.0 (default speed) to 2.0 (300% faster)").defineInRange("sprintSpeedBoost", 0.3, 0.0, 2.0);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

