/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.incombat.capability;

import com.everydayxp.incombat.events.PlayerCombatStateEvent;
import com.everydayxp.incombat.network.InCombatPacketHandler;
import com.everydayxp.incombat.network.SyncInCombatPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class InCombatData {
    private final Player player;
    private boolean inCombat = false;
    private int combatTime = 0;

    public InCombatData(Player player) {
        this.player = player;
    }

    public void updateTime(int time) {
        PlayerCombatStateEvent.Start event = new PlayerCombatStateEvent.Start(this.player, this, time);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            this.combatTime = event.getNewCombatTime();
            if (!this.inCombat) {
                this.inCombat = true;
            }
        }
    }

    public void tick() {
        if (this.combatTime > 0) {
            --this.combatTime;
        }
        if (this.inCombat && this.combatTime <= 0) {
            MinecraftForge.EVENT_BUS.post((Event)new PlayerCombatStateEvent.End(this.player, this));
            this.inCombat = false;
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer splayer = (ServerPlayer)player;
                InCombatPacketHandler.sendToPlayer(splayer, new SyncInCombatPacket(false, 0));
            }
        }
    }

    public void copyFrom(InCombatData source) {
        this.inCombat = source.inCombat;
        this.combatTime = source.combatTime;
    }

    public void setData(boolean inCombat, int combatTime) {
        this.inCombat = inCombat;
        this.combatTime = combatTime;
    }

    public void saveNBT(CompoundTag tag) {
        tag.m_128379_("InCombat", this.inCombat);
        tag.m_128405_("CombatTime", this.combatTime);
    }

    public void loadNBT(CompoundTag tag) {
        this.inCombat = tag.m_128471_("InCombat");
        this.combatTime = tag.m_128451_("CombatTime");
    }

    public boolean isInCombat() {
        return this.inCombat;
    }

    public int getCombatTime() {
        return this.combatTime;
    }

    public Player getPlayer() {
        return this.player;
    }
}

