/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.incombat.events;

import com.everydayxp.incombat.capability.InCombatCapability;
import com.everydayxp.incombat.config.InCombatConfig;
import com.everydayxp.incombat.network.InCombatPacketHandler;
import com.everydayxp.incombat.network.SyncInCombatPacket;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="incombat", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CombatEventHandler {
    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            event.addCapability(new ResourceLocation("incombat", "incombat_data"), (ICapabilityProvider)new InCombatCapability(player));
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        player.getCapability(InCombatCapability.IN_COMBAT).ifPresent(data -> {
            if (data.isInCombat()) {
                boolean canPlace;
                ItemStack stack = event.getItemStack();
                Item item = stack.m_41720_();
                ResourceLocation itemRL = ForgeRegistries.ITEMS.getKey((Object)item);
                List allowed = (List)InCombatConfig.ALLOWED_BLOCKS.get();
                boolean isBlock = item instanceof BlockItem;
                boolean bl = canPlace = isBlock && allowed.stream().anyMatch(s -> s.equals(itemRL != null ? itemRL.toString() : ""));
                if (isBlock && !canPlace) {
                    event.setCanceled(true);
                }
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingAttackEvent event) {
        if (!((Boolean)InCombatConfig.ENTER_COMBAT_ON_ATTACK.get()).booleanValue()) {
            return;
        }
        Entity source = event.getSource().m_7639_();
        if (source instanceof Player) {
            Player player = (Player)source;
            player.getCapability(InCombatCapability.IN_COMBAT).ifPresent(data -> {
                int combatTicks = (Integer)InCombatConfig.COMBAT_TIME.get();
                data.updateTime(combatTicks);
                if (!player.m_9236_().m_5776_() && player instanceof ServerPlayer) {
                    ServerPlayer splayer = (ServerPlayer)player;
                    InCombatPacketHandler.sendToPlayer(splayer, new SyncInCombatPacket(true, combatTicks));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingAttackEvent event) {
        if (!((Boolean)InCombatConfig.ENTER_COMBAT_ON_HURT.get()).booleanValue()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.getCapability(InCombatCapability.IN_COMBAT).ifPresent(data -> {
                int combatTicks = (Integer)InCombatConfig.COMBAT_TIME.get();
                data.updateTime(combatTicks);
                if (!player.m_9236_().m_5776_() && player instanceof ServerPlayer) {
                    ServerPlayer splayer = (ServerPlayer)player;
                    InCombatPacketHandler.sendToPlayer(splayer, new SyncInCombatPacket(true, combatTicks));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        Level level = event.level;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (level.f_46443_) {
            return;
        }
        for (Player p : level.m_6907_()) {
            if (!(p instanceof ServerPlayer)) continue;
            ServerPlayer player = (ServerPlayer)p;
            player.getCapability(InCombatCapability.IN_COMBAT).ifPresent(data -> {
                data.tick();
                if (data.isInCombat() && player.m_20142_()) {
                    player.m_6858_(false);
                }
            });
        }
    }
}

