/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.incombat.capability;

import com.everydayxp.incombat.capability.InCombatData;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InCombatCapability
implements ICapabilityProvider {
    public static final Capability<InCombatData> IN_COMBAT = CapabilityManager.get((CapabilityToken)new CapabilityToken<InCombatData>(){});
    private final Player player;
    private InCombatData data = null;
    private final LazyOptional<InCombatData> optional = LazyOptional.of(this::createData);

    public InCombatCapability(Player player) {
        this.player = player;
    }

    public InCombatData createData() {
        if (this.data == null) {
            this.data = new InCombatData(this.player);
        }
        return this.data;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == IN_COMBAT ? this.optional.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.createData().saveNBT(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.createData().loadNBT(tag);
    }
}

