/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.incombat.config;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class InCombatConfig {
    public static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.ConfigValue<Integer> COMBAT_TIME;
    public static final ForgeConfigSpec.ConfigValue<Double> SPEED_REDUCTION;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ALLOWED_BLOCKS;
    public static final ForgeConfigSpec.BooleanValue ENTER_COMBAT_ON_ATTACK;
    public static final ForgeConfigSpec.BooleanValue ENTER_COMBAT_ON_HURT;
    public static final ForgeConfigSpec.Builder CLIENT_BUILDER;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SHOW_OVERLAY;
    public static final ForgeConfigSpec.ConfigValue<Integer> OVERLAY_POS_X;
    public static final ForgeConfigSpec.ConfigValue<Integer> OVERLAY_POS_Y;
    public static final ForgeConfigSpec.IntValue ICON_SIZE;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ForgeConfigSpec CLIENT_SPEC;

    static {
        CLIENT_BUILDER = new ForgeConfigSpec.Builder();
        COMMON_BUILDER.comment("General options for InCombat");
        COMBAT_TIME = COMMON_BUILDER.comment("Combat duration in ticks after the last hit. (160 = 8 seconds by default, 20 ticks = 1 second)").defineInRange("combatTime", 160, 20, 1200);
        SPEED_REDUCTION = COMMON_BUILDER.comment("Speed reduction percentage while in combat. (0.3 = 30% slower)").define("speedReduction", (Object)0.3);
        ALLOWED_BLOCKS = COMMON_BUILDER.comment("List of blocks that can be placed during combat (example: minecraft:torch)").defineListAllowEmpty("allowedBlocks", List.of("minecraft:torch", "minecraft:lantern"), s -> s instanceof String);
        ENTER_COMBAT_ON_ATTACK = COMMON_BUILDER.comment("Enter combat when attacking another").define("enterCombatOnAttack", true);
        ENTER_COMBAT_ON_HURT = COMMON_BUILDER.comment("Enter combat when receiving damage").define("enterCombatOnHurt", true);
        COMMON_SPEC = COMMON_BUILDER.build();
        CLIENT_BUILDER.comment("Client-side HUD / overlay options");
        SHOW_OVERLAY = CLIENT_BUILDER.comment("Show combat HUD overlay when in combat").define("showOverlay", true);
        OVERLAY_POS_X = CLIENT_BUILDER.comment("Horizontal overlay position in pixels relative to screen center").defineInRange("overlayPosX", 0, 0, 3840);
        OVERLAY_POS_Y = CLIENT_BUILDER.comment("Vertical overlay position in pixels from screen bottom").defineInRange("overlayPosY", 38, 0, 2160);
        ICON_SIZE = CLIENT_BUILDER.comment("HUD icon size in pixels").defineInRange("iconSize", 32, 8, 64);
        CLIENT_SPEC = CLIENT_BUILDER.build();
    }
}

