/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.incombat.network;

import com.everydayxp.incombat.capability.InCombatCapability;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class SyncInCombatPacket {
    private final boolean inCombat;
    private final int combatTime;

    public SyncInCombatPacket(boolean inCombat, int combatTime) {
        this.inCombat = inCombat;
        this.combatTime = combatTime;
    }

    public SyncInCombatPacket(FriendlyByteBuf buf) {
        this.inCombat = buf.readBoolean();
        this.combatTime = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.inCombat);
        buf.writeInt(this.combatTime);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91074_ != null) {
                Minecraft.m_91087_().f_91074_.getCapability(InCombatCapability.IN_COMBAT).ifPresent(data -> data.setData(this.inCombat, this.combatTime));
            }
        });
        ctx.setPacketHandled(true);
    }
}

