/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.incombat.util;

import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class ResourceLocationUtil {
    public static boolean isValid(String str) {
        try {
            new ResourceLocation(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean matchesWildcard(ResourceLocation rl, String pattern) {
        if (rl == null || pattern == null) {
            return false;
        }
        String rlStr = rl.toString().toLowerCase();
        String patStr = pattern.toLowerCase();
        if (patStr.contains("*")) {
            String regex = patStr.replace(".", "\\.").replace("*", ".*");
            return rlStr.matches(regex);
        }
        return rlStr.equals(patStr);
    }

    public static boolean isAllowed(ResourceLocation rl, List<? extends String> allowed) {
        for (String string : allowed) {
            if (!ResourceLocationUtil.matchesWildcard(rl, string)) continue;
            return true;
        }
        return false;
    }
}

