/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.servercreatorbanner;

import com.bisecthosting.mods.bhmenu.config.GlobalConfigs;
import com.bisecthosting.mods.bhmenu.config.components.text.TextConfigEditBox;
import com.bisecthosting.mods.bhmenu.config.components.toggle.BooleanConfigButton;
import com.bisecthosting.mods.bhmenu.config.lists.ModuleConfigList;
import com.bisecthosting.mods.bhmenu.config.values.BooleanHolder;
import com.bisecthosting.mods.bhmenu.config.values.StringHolder;
import com.bisecthosting.mods.bhmenu.modules.BaseModule;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.GameShuttingDownEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerCreatorBanner
extends BaseModule {
    public static final Logger LOGGER = LogManager.getLogger();
    public ModConfigSpec.ConfigValue<String> title;
    public ModConfigSpec.ConfigValue<String> description;
    public ModConfigSpec.BooleanValue useLanguageFiles;

    public ServerCreatorBanner() {
        super("server_creator_banner");
    }

    @Override
    public void buildConfigs(ModConfigSpec.Builder builder) {
        builder.comment("Modpack Configs").push("pack");
        this.title = builder.comment("The title to display at the top of the entry.").define("title", (Object)"Need a server?");
        this.description = builder.comment("The description to display below the title.").define("description", (Object)"Click me to get your own server!");
        this.useLanguageFiles = builder.comment(new String[]{"Set this to true to use specific language translation keys.", "This requires a custom mod that adds resource files, such as OpenLoader.", "Use 'server_entry.title' key for the Title;", "Use 'server_entry.description' key for the Description."}).define("use_language_files", false);
        builder.pop().comment("User Configs").push("user");
        builder.pop();
    }

    @Override
    public boolean hasPackConfigs() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void populatePackConfigs(ModuleConfigList configs, Consumer<ModuleConfigList.Entry> entries) {
        MutableComponent text = Component.translatable((String)"modules.server_creator_banner.config.title");
        ModConfigSpec.ValueSpec valueSpec = (ModConfigSpec.ValueSpec)GlobalConfigs.getSpec().getSpec().get(this.title.getPath());
        entries.accept(new ModuleConfigList.Entry(configs, valueSpec.getComment(), (Component)text, (AbstractWidget)new TextConfigEditBox(new StringHolder(this.title), Minecraft.getInstance().font, 0, 0, 0, 20, (Component)text)));
        text = Component.translatable((String)"modules.server_creator_banner.config.description");
        valueSpec = (ModConfigSpec.ValueSpec)GlobalConfigs.getSpec().getSpec().get(this.description.getPath());
        entries.accept(new ModuleConfigList.Entry(configs, valueSpec.getComment(), (Component)text, (AbstractWidget)new TextConfigEditBox(new StringHolder(this.description), Minecraft.getInstance().font, 0, 0, 0, 20, (Component)text)));
        text = Component.translatable((String)"modules.server_creator_banner.config.use_language_files");
        valueSpec = (ModConfigSpec.ValueSpec)GlobalConfigs.getSpec().getSpec().get(this.useLanguageFiles.getPath());
        entries.accept(new ModuleConfigList.Entry(configs, valueSpec.getComment(), (Component)text, (AbstractWidget)new BooleanConfigButton(new BooleanHolder(this.useLanguageFiles), 0, 0, 0, 20)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void populateUserConfigs(ModuleConfigList configs, Consumer<ModuleConfigList.Entry> entries) {
    }

    public Component getTitle() {
        return (Boolean)this.useLanguageFiles.get() != false ? Component.translatable((String)"server_entry.title") : Component.literal((String)((String)this.title.get()));
    }

    public Component getDescription() {
        return (Boolean)this.useLanguageFiles.get() != false ? Component.translatable((String)"server_entry.description") : Component.literal((String)((String)this.description.get()));
    }

    @SubscribeEvent
    public void onClientInit(GameShuttingDownEvent setup) {
    }
}

