/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.config;

import com.bisecthosting.mods.bhmenu.screen.config.PackConfigScreen;
import java.util.Properties;
import java.util.function.Function;

public abstract class ConfigValue<T> {
    protected final Properties properties;
    protected final String key;
    protected final T defaultValue;
    protected String[] comments;
    private boolean changed;
    protected T value;

    public ConfigValue(Properties properties, String key, T defaultValue, String ... comments) {
        this.properties = properties;
        this.key = key;
        this.defaultValue = defaultValue;
        this.comments = comments;
        properties.computeIfAbsent(key, (Function<? super Object, ?>)((Function<Object, Object>)k -> String.valueOf(defaultValue)));
        this.fetch();
    }

    public void setValue(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public void fetch() {
        this.readValue();
        this.changed = false;
    }

    public void fetchDefaultValue() {
        this.setValue(this.defaultValue);
        this.writeValue();
    }

    public T getDefault() {
        return this.defaultValue;
    }

    public String[] getComments() {
        return this.comments;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    protected void clearChanged() {
        this.changed = false;
    }

    public void writeValue() {
        String stringValue = String.valueOf(this.value);
        if (!this.properties.get(this.key).equals(stringValue)) {
            this.properties.put(this.key, stringValue);
            this.changed = true;
            PackConfigScreen.hasChanged = true;
        }
    }

    public abstract void readValue();
}

