/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.publicserverlist.data.api;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.apicalls.ApiCalls;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.PublicServerLoadException;
import com.google.gson.JsonArray;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.class_642;

public class PublicServerApiData {
    private static final String PUBLIC_SERVER_API = "https://www.bisecthosting.com/api/v1/public_servers";

    public static CompletableFuture<List<class_642>> reloadData(String packId) {
        return CompletableFuture.supplyAsync(() -> PublicServerApiData.loadServers(packId));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<class_642> loadServers(String packId) {
        try {
            if (packId.isEmpty()) {
                throw new PublicServerLoadException("Empty pack id provided. Contact modpack author to add one to this pack.");
            }
            try (InputStream urlStream = new URL("https://www.bisecthosting.com/api/v1/public_servers?id=" + packId).openStream();){
                ArrayList list2 = new ArrayList();
                JsonArray jsonServerList = ApiCalls.JSON_PARSER.parse((Reader)new InputStreamReader(urlStream)).getAsJsonArray();
                if (jsonServerList.size() == 0) {
                    ArrayList<class_642> arrayList = new ArrayList<class_642>();
                    return arrayList;
                }
                jsonServerList.forEach(jsonServer -> list2.add((RawServerInfo)ApiCalls.GSON.fromJson(jsonServer, RawServerInfo.class)));
                List<class_642> list = list2.stream().map(raw -> new class_642(((RawServerInfo)raw).name, ((RawServerInfo)raw).ip + ":" + ((RawServerInfo)raw).port, false)).collect(Collectors.toList());
                return list;
            }
        }
        catch (IOException e) {
            ModRef.LOGGER.error("Could not load public servers. Check logs for the error.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static class RawServerInfo {
        private final String name;
        private final String ip;
        private final int port;

        public RawServerInfo(String name, String ip, int port) {
            this.name = name;
            this.ip = ip;
            this.port = port;
        }

        public String toString() {
            return "RawServerInfo{name='" + this.name + '\'' + ", ip='" + this.ip + '\'' + ", port=" + this.port + '}';
        }
    }
}

