/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.data.ServerListData;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen.PublicServerLoadingScreen;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen.PublicServerSelectionList;
import com.bisecthosting.mods.bhmenu.screen.EditBoxComponent;
import com.bisecthosting.mods.bhmenu.screen.TickBoxButton;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1074;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_339;
import net.minecraft.class_412;
import net.minecraft.class_4185;
import net.minecraft.class_422;
import net.minecraft.class_437;
import net.minecraft.class_500;
import net.minecraft.class_642;
import net.minecraft.class_644;

public class PublicServersScreen
extends class_437 {
    private static final class_2561 TITLE_TEXT = new class_2588("modules.public_server_list.title", new Object[0]);
    private static final Supplier<String> JOIN_SERVER_TEXT = () -> class_1074.method_4662((String)"selectServer.select", (Object[])new Object[0]);
    private static final Supplier<String> ADD_SERVER_TEXT = () -> class_1074.method_4662((String)"selectServer.add", (Object[])new Object[0]);
    private static final Supplier<String> BACK_TEXT = () -> class_1074.method_4662((String)"gui.back", (Object[])new Object[0]);
    private static final Supplier<String> REFRESH_TEXT = () -> class_1074.method_4662((String)"selectServer.refresh", (Object[])new Object[0]);
    private static final Supplier<String> HOW_TO_TEXT = () -> class_1074.method_4662((String)"modules.public_server_list.how_to", (Object[])new Object[0]);
    private static final Supplier<String> NAME_FILTER_TEXT = () -> class_1074.method_4662((String)"modules.public_server_list.filter.name", (Object[])new Object[0]);
    private static final Supplier<String> PING_SORT_TEXT = () -> class_1074.method_4662((String)"modules.public_server_list.sort.ping", (Object[])new Object[0]);
    private static final Supplier<String> PLAYER_COUNT_SORT_TEXT = () -> class_1074.method_4662((String)"modules.public_server_list.sort.player_count", (Object[])new Object[0]);
    private static final URI HOW_TO_URI = URI.create("https://www.bisecthosting.com/clients/index.php?rp=/knowledgebase/348/How-to-add-a-modpack-server-to-the-public-server-list.html");
    private final class_644 pinger = new class_644();
    private PublicServerSelectionList serverSelectionList;
    private ServerListData servers;
    private class_4185 addButton;
    private class_4185 joinButton;
    private class_4185 howToButton;
    private EditBoxComponent searchBar;
    private TickBoxButton pingSort;
    private TickBoxButton playerCountSort;
    public static final float SPLIT = 0.4f;
    private List<String> renderedTooltip;
    private boolean openedLink;
    public final class_500 multiplayerScreen;
    private boolean hasInit;

    public PublicServersScreen(class_500 multiplayerScreen, List<class_642> servers) {
        super(TITLE_TEXT);
        this.multiplayerScreen = multiplayerScreen;
        this.servers = new ServerListData(servers);
    }

    protected void init() {
        int splitWidth = (int)((float)this.width * 0.4f);
        if (this.hasInit) {
            this.serverSelectionList.updateSize(this.width - splitWidth, this.height, 32, this.height - 8);
            this.serverSelectionList.setLeftPos(splitWidth);
        } else {
            this.hasInit = true;
            this.serverSelectionList = new PublicServerSelectionList(this, this.minecraft, this.width - splitWidth, this.height, 32, this.height - 8, 36);
            this.serverSelectionList.setLeftPos(splitWidth);
            this.serverSelectionList.updateOnlineServers(this.servers);
        }
        this.children.add(this.serverSelectionList);
        String oldText = null;
        if (this.searchBar != null) {
            oldText = this.searchBar.getValue();
        }
        this.searchBar = new EditBoxComponent(this.minecraft.field_1772, 10, 52, splitWidth - 20, 20, "");
        this.searchBar.setResponder(this.serverSelectionList::setNameFilter);
        if (oldText != null) {
            this.searchBar.setValue(oldText);
        }
        this.addButton(this.searchBar);
        this.pingSort = new TickBoxButton(splitWidth - 40, 90, this.pingSort, this.serverSelectionList::togglePingSort);
        this.addButton((class_339)this.pingSort);
        this.playerCountSort = new TickBoxButton(splitWidth - 40, 124, this.playerCountSort, this.serverSelectionList::togglePlayerCountSort);
        this.addButton((class_339)this.playerCountSort);
        int buttonWidth = Math.min(100, splitWidth / 2 - 4);
        class_4185 refreshButton = new class_4185(splitWidth / 2 - buttonWidth - 2, this.height - 28, buttonWidth, 20, REFRESH_TEXT.get(), btn -> this.minecraft.method_1507((class_437)new PublicServerLoadingScreen((class_437)this.multiplayerScreen)));
        class_4185 backButton = new class_4185(splitWidth / 2 + 2, this.height - 28, buttonWidth, 20, BACK_TEXT.get(), btn -> this.onClose());
        this.joinButton = new class_4185(splitWidth / 2 - buttonWidth - 2, this.height - 52, buttonWidth, 20, JOIN_SERVER_TEXT.get(), btn -> this.joinSelectedServer());
        this.joinButton.active = false;
        this.addButton = new class_4185(splitWidth / 2 + 2, this.height - 52, buttonWidth, 20, ADD_SERVER_TEXT.get(), btn -> this.addSelectedServer());
        this.addButton.active = false;
        this.howToButton = (class_4185)this.addButton((class_339)new class_4185(splitWidth / 2 - buttonWidth - 2, this.height - 76, buttonWidth * 2 + 4, 20, HOW_TO_TEXT.get(), btn -> this.openHowToPage()));
        this.addButton((class_339)refreshButton);
        this.addButton((class_339)backButton);
        this.addButton((class_339)this.addButton);
        this.addButton((class_339)this.joinButton);
    }

    public void tick() {
        super.tick();
        this.pinger.method_3000();
        this.searchBar.tick();
        this.serverSelectionList.tick();
        if (this.openedLink) {
            this.howToButton.changeFocus(false);
            this.openedLink = false;
        }
    }

    public void render(int mouseX, int mouseY, float delta) {
        int splitWidth = (int)((float)this.width * 0.4f);
        this.renderedTooltip = null;
        this.renderBackground();
        this.serverSelectionList.render(mouseX, mouseY, delta);
        super.render(mouseX, mouseY, delta);
        Objects.requireNonNull(this.font);
        float fontHeight = 9.0f;
        this.drawCenteredString(this.font, this.title.method_10863(), this.width / 2, 10, -1);
        if (this.renderedTooltip != null) {
            this.renderTooltip(this.renderedTooltip, mouseX, mouseY);
        }
        this.drawCenteredString(this.font, NAME_FILTER_TEXT.get(), splitWidth / 2, 32, -1);
        this.drawString(this.font, PING_SORT_TEXT.get(), 20, 90 + (int)((20.0f - fontHeight) / 2.0f), -1);
        this.drawString(this.font, PLAYER_COUNT_SORT_TEXT.get(), 20, 124 + (int)((20.0f - fontHeight) / 2.0f), -1);
    }

    public void joinSelectedServer() {
        PublicServerSelectionList.Entry entry = (PublicServerSelectionList.Entry)this.serverSelectionList.getSelected();
        if (entry instanceof PublicServerSelectionList.ServerEntry) {
            this.join((PublicServerSelectionList.ServerEntry)entry);
        }
    }

    public void join(PublicServerSelectionList.ServerEntry entry) {
        this.serverSelectionList.setLastJoined(entry);
        this.join(entry.getServerInfo());
    }

    private void join(class_642 server) {
        this.minecraft.method_1507((class_437)new class_412((class_437)this, this.minecraft, server));
    }

    public void addSelectedServer() {
        PublicServerSelectionList.Entry entry = (PublicServerSelectionList.Entry)this.serverSelectionList.getSelected();
        if (entry instanceof PublicServerSelectionList.ServerEntry) {
            class_642 data = ((PublicServerSelectionList.ServerEntry)entry).getServerInfo();
            this.multiplayerScreen.field_3051 = new class_642(data.field_3752, data.field_3761, false);
            this.minecraft.method_1507((class_437)new class_422((class_437)this, arg_0 -> ((class_500)this.multiplayerScreen).method_20379(arg_0), this.multiplayerScreen.field_3051));
        }
    }

    public void openHowToPage() {
        ModRef.LOGGER.info("Opening knowledgebase " + HOW_TO_URI);
        class_156.method_668().method_673(HOW_TO_URI);
        this.openedLink = true;
    }

    public void setSelected(PublicServerSelectionList.ServerEntry entry) {
        this.serverSelectionList.setSelected(entry);
        this.onSelectedChange();
    }

    protected void onSelectedChange() {
        this.joinButton.active = false;
        this.addButton.active = false;
        PublicServerSelectionList.Entry entry = (PublicServerSelectionList.Entry)this.serverSelectionList.getSelected();
        if (entry instanceof PublicServerSelectionList.ServerEntry) {
            this.joinButton.active = true;
            this.addButton.active = true;
        }
    }

    public void removed() {
        this.pinger.method_3004();
        this.serverSelectionList.stopPingingServer();
    }

    public void onClose() {
        if (!this.searchBar.getValue().isEmpty()) {
            this.searchBar.setValue("");
        } else {
            this.minecraft.method_1507((class_437)this.multiplayerScreen);
        }
    }

    public void setRenderedTooltip(List<String> tooltip) {
        this.renderedTooltip = tooltip;
    }

    public class_644 getPinger() {
        return this.pinger;
    }

    public ServerListData getServers() {
        return this.servers;
    }
}

