/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.screen.config.lists;

import com.bisecthosting.mods.bhmenu.screen.config.IConfigurable;
import com.bisecthosting.mods.bhmenu.screen.config.ModuleConfigScreen;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4265;

public class ModuleConfigList
extends class_4265<Entry> {
    private ModuleConfigScreen screen;

    public ModuleConfigList(ModuleConfigScreen screen, class_310 mc, int width, int height, int y0, int y1, int itemHeight) {
        super(mc, width, height, y0, y1, itemHeight);
        this.screen = screen;
    }

    public void populateModuleConfigList(BiConsumer<ModuleConfigList, Consumer<Entry>> populator) {
        populator.accept(this, x$0 -> this.addEntry((class_350.class_351)x$0));
    }

    public void render(int mouseX, int mouseY, float delta) {
        super.render(mouseX, mouseY, delta);
        Entry entry = (Entry)this.getEntryAtPosition(mouseX, mouseY);
        if (mouseX < this.width / 2 && entry != null && !entry.comments.isEmpty()) {
            this.screen.renderTooltip(entry.comments, mouseX, mouseY);
        }
    }

    protected boolean isFocused() {
        return this.screen.getFocused() == this;
    }

    public int getRowWidth() {
        return this.width - 40;
    }

    protected int getScrollbarPosition() {
        return this.field_19087 - 6;
    }

    public void saveAll() {
        for (Entry entry : this.children()) {
            entry.save();
        }
    }

    public void discardAll() {
        for (Entry entry : this.children()) {
            entry.discard();
        }
    }

    public static class Entry
    extends class_4265.class_4266<Entry> {
        private final ModuleConfigList parent;
        private final List<String> comments = new ArrayList<String>();
        private final String text;
        private final class_339 configButton;
        private final List<class_339> children;

        public Entry(ModuleConfigList parent, String[] comments, String text, class_339 button) {
            this.parent = parent;
            for (String comment : comments) {
                this.comments.add(comment);
            }
            this.text = text;
            this.configButton = button;
            this.children = Lists.newArrayList((Object[])new class_339[]{this.configButton});
        }

        public void render(int index, int top, int left, int width, int innerHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            this.configButton.x = left + width / 2 + 10;
            this.configButton.y = top + (innerHeight - this.configButton.height) / 2;
            this.configButton.setWidth(width / 2 - 10);
            this.configButton.render(mouseX, mouseY, delta);
            class_327 font = class_310.method_1551().field_1772;
            float f = left;
            float f2 = top;
            Objects.requireNonNull(font);
            font.method_1729(this.text, f, f2 + (float)(innerHeight - 9) / 2.0f, 0xFFFFFF);
        }

        public void save() {
            if (this.configButton instanceof IConfigurable) {
                ((IConfigurable)this.configButton).save();
            }
        }

        public void discard() {
            if (this.configButton instanceof IConfigurable) {
                ((IConfigurable)this.configButton).discard();
            }
        }

        public List<? extends class_364> children() {
            return this.children;
        }
    }
}

