/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.config;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.ModRoot;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="bhmenu", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class GlobalConfigs {
    private static final Constructor<ModConfig.ConfigReloading> MOD_CONFIG$RELOADING_CONSTRUCTOR = ObfuscationReflectionHelper.findConstructor(ModConfig.ConfigReloading.class, (Class[])new Class[]{ModConfig.class});
    private static final ConcurrentHashMap<String, ModConfig> CONFIG_TRACKER_FILE_MAP = (ConcurrentHashMap)ObfuscationReflectionHelper.getPrivateValue(ConfigTracker.class, (Object)ConfigTracker.INSTANCE, (String)"fileMap");
    public static final File MOD_CONFIG_FOLDER = new File(Minecraft.func_71410_x().field_71412_D, "bhmenu");
    public static ForgeConfigSpec.ConfigValue<String> partnerId;
    public static ForgeConfigSpec.ConfigValue<String> packId;
    public static ForgeConfigSpec.BooleanValue packEditMode;
    private static ForgeConfigSpec spec;

    public GlobalConfigs() {
        MOD_CONFIG_FOLDER.mkdirs();
    }

    public static ForgeConfigSpec getSpec() {
        return spec;
    }

    public static void register() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        ModRoot.get().modules.configure(builder);
        partnerId = builder.comment(new String[]{"Your partner ID to use in during the ordering process.", "Without this you will not be credited for the purchases.", "(Your partner id is not the same as your referral link, please check your client area to find your partner id at https://www.bisecthosting.com/partners/console.php)."}).define("partner_id", (Object)"");
        packId = builder.comment(new String[]{"The id of this modpack.", "(This is BH internal pack id; Find the id here: https://www.bisecthosting.com/partners/console.php)"}).define("pack_id", (Object)"");
        packEditMode = builder.comment(new String[]{"Set this to false to disable pack config screen and enable user configs instead.", "This should always be done by the pack author once they are done with configuring the pack.", "To re-enable Pack Edit Mode, please edit the config file."}).define("pack_edit_mode", true);
        spec = builder.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, spec);
    }

    public static void reloadConfigs() {
        try {
            ModConfig config = CONFIG_TRACKER_FILE_MAP.get(GlobalConfigs.defaultConfigName(ModConfig.Type.CLIENT, "bhmenu"));
            ModRoot.get().modContainer.dispatchConfigEvent((ModConfig.ModConfigEvent)MOD_CONFIG$RELOADING_CONSTRUCTOR.newInstance(config));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            ModRef.LOGGER.error("Failed to reload configs.", (Throwable)e);
        }
    }

    private static String defaultConfigName(ModConfig.Type type, String modId) {
        return String.format(Locale.ROOT, "%s-%s.toml", modId, type.extension());
    }
}

