/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.config.lists;

import com.bisecthosting.mods.bhmenu.client.screen.IGuiComponent;
import com.bisecthosting.mods.bhmenu.config.IConfigurable;
import com.bisecthosting.mods.bhmenu.config.ModuleConfigScreen;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.util.StringUtils;

public class ModuleConfigList
extends GuiListExtended<Entry> {
    private ModuleConfigScreen screen;

    public ModuleConfigList(ModuleConfigScreen screen, Minecraft mc, int width, int height, int y0, int y1, int itemHeight) {
        super(mc, width, height, y0, y1, itemHeight);
        this.screen = screen;
    }

    public void saveAll() {
        for (Entry entry : this.func_195074_b()) {
            entry.save();
        }
    }

    public void populateModuleConfigList(BiConsumer<ModuleConfigList, Consumer<Entry>> populator) {
        populator.accept(this, arg_0 -> ((ModuleConfigList)this).func_195085_a(arg_0));
    }

    public void func_148128_a(int mouseX, int mouseY, float delta) {
        super.func_148128_a(mouseX, mouseY, delta);
        int entryId = this.func_195083_a(mouseX, mouseY);
        Entry entry = (Entry)((Object)this.func_195074_b().get(entryId));
        if (mouseX < this.field_148155_a / 2 && entry != null && !entry.comments.isEmpty()) {
            this.screen.func_146283_a(entry.comments, mouseX, mouseY);
        }
    }

    public int func_148139_c() {
        return this.field_148155_a - 40;
    }

    protected int func_148137_d() {
        return this.field_148155_a - 6;
    }

    public static class Entry
    extends GuiListExtended.IGuiListEntry<Entry> {
        private final ModuleConfigList parent;
        private final List<String> comments = new ArrayList<String>();
        private final String text;
        private final IGuiComponent configButton;
        private final List<IGuiComponent> children;

        public Entry(ModuleConfigList parent, String comments, String text, IGuiComponent button) {
            this.parent = parent;
            if (!StringUtils.func_151246_b((String)comments)) {
                this.comments.addAll(Arrays.asList(comments.split("\n")));
            }
            this.text = text;
            this.configButton = button;
            this.children = Lists.newArrayList((Object[])new IGuiComponent[]{this.configButton});
        }

        public void func_194999_a(int width, int height, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
            this.configButton.setX(this.func_195002_d() + width / 2 + 10);
            this.configButton.setY(this.func_195001_c() + (height - this.configButton.getHeight()) / 2);
            this.configButton.setWidth(width / 2 - 10);
            this.configButton.render(mouseX, mouseY, partialTicks);
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            font.func_211126_b(this.text, (float)this.func_195002_d(), (float)this.func_195001_c() + (float)(height - font.field_78288_b) / 2.0f, 0xFFFFFF);
        }

        public void save() {
            if (this.configButton instanceof IConfigurable) {
                ((IConfigurable)((Object)this.configButton)).save();
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            for (IGuiComponent child : this.children) {
                if (!(child instanceof IGuiEventListener) || !((IGuiEventListener)child).mouseClicked(mouseX, mouseY, button)) continue;
                return true;
            }
            return false;
        }

        public boolean charTyped(char key, int code) {
            for (IGuiComponent child : this.children) {
                if (!(child instanceof IGuiEventListener) || !((IGuiEventListener)child).charTyped(key, code)) continue;
                return true;
            }
            return false;
        }

        public boolean keyPressed(int keycode, int scancode, int modifiers) {
            for (IGuiComponent child : this.children) {
                if (!(child instanceof IGuiEventListener) || !((IGuiEventListener)child).keyPressed(keycode, scancode, modifiers)) continue;
                return true;
            }
            return false;
        }
    }
}

