/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.config.lists;

import com.bisecthosting.mods.bhmenu.ModRoot;
import com.bisecthosting.mods.bhmenu.config.ModuleConfigScreen;
import com.bisecthosting.mods.bhmenu.config.components.ConfigButtonComponent;
import com.bisecthosting.mods.bhmenu.config.components.toggle.TickBoxConfigComponent;
import com.bisecthosting.mods.bhmenu.config.values.BooleanHolder;
import com.bisecthosting.mods.bhmenu.modules.IModule;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;

public class ModuleSelectionList
extends GuiListExtended<Entry> {
    private GuiScreen parent;

    public ModuleSelectionList(GuiScreen parent, Minecraft mc, int width, int height, int y0, int y1, int itemHeight) {
        super(mc, width, height, y0, y1, itemHeight);
        this.parent = parent;
    }

    public void addPackEntry(IModule module) {
        this.func_195085_a(new PackEntry(module));
    }

    public void addUserEntry(IModule module) {
        this.func_195085_a(new UserEntry(module));
    }

    public void saveAll() {
        for (Entry entry : this.func_195074_b()) {
            entry.save();
        }
    }

    protected int func_148137_d() {
        return this.field_148152_e - 6;
    }

    public int func_148139_c() {
        return Math.min(this.field_148155_a - 40, 260);
    }

    public class UserEntry
    extends Entry {
        private final GuiButton configButton;
        private final List<GuiButton> children;

        public UserEntry(final IModule module) {
            this.configButton = new GuiButton(1, 0, 0, 0, 20, I18n.func_135052_a((String)("screen.config.modules." + module.getId() + ".name"), (Object[])new Object[0])){

                public void func_194829_a(double mouseX, double mouseY) {
                    super.func_194829_a(mouseX, mouseY);
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new ModuleConfigScreen(ModuleSelectionList.this.parent, module, module::populateUserConfigs));
                }
            };
            if (!module.hasUserConfigs()) {
                this.configButton.field_146124_l = false;
            }
            this.children = Lists.newArrayList((Object[])new GuiButton[]{this.configButton});
        }

        public void func_194999_a(int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
            this.configButton.field_146128_h = ModuleSelectionList.this.field_148152_e;
            this.configButton.func_175211_a(ModuleSelectionList.this.field_148155_a);
            this.configButton.field_146129_i = ModuleSelectionList.this.field_148153_b;
            this.configButton.func_194828_a(mouseX, mouseY, partialTicks);
        }

        @Override
        public void save() {
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            for (GuiButton child : this.children) {
                if (!child.mouseClicked(mouseX, mouseY, button)) continue;
                return true;
            }
            return false;
        }
    }

    public class PackEntry
    extends Entry {
        private final IModule module;
        private final ConfigButtonComponent toggle;
        private final GuiButton configButton;
        private final List<GuiButton> children;

        public PackEntry(final IModule module) {
            this.module = module;
            this.toggle = new TickBoxConfigComponent(0, new BooleanHolder(ModRoot.get().modules.getEnabledValue(module.getId())), 0, 0, 20, 20);
            this.configButton = new GuiButton(1, 0, 0, 0, 20, I18n.func_135052_a((String)("screen.config.modules." + module.getId() + ".name"), (Object[])new Object[0])){

                public void func_194829_a(double mouseX, double mouseY) {
                    super.func_194829_a(mouseX, mouseY);
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new ModuleConfigScreen(ModuleSelectionList.this.parent, module, module::populatePackConfigs));
                }
            };
            if (!module.hasPackConfigs()) {
                this.configButton.field_146124_l = false;
            }
            this.children = Lists.newArrayList((Object[])new GuiButton[]{this.toggle, this.configButton});
        }

        public void func_194999_a(int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
            this.toggle.field_146128_h = ModuleSelectionList.this.field_148152_e;
            this.configButton.field_146128_h = ModuleSelectionList.this.field_148152_e + 30;
            this.configButton.func_175211_a(ModuleSelectionList.this.field_148155_a - 30);
            this.children.forEach(child -> {
                child.field_146129_i = ModuleSelectionList.this.field_148153_b;
                child.func_194828_a(mouseX, mouseY, partialTicks);
            });
        }

        @Override
        public void save() {
            this.toggle.save();
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            for (GuiButton child : this.children) {
                if (!child.mouseClicked(mouseX, mouseY, button)) continue;
                return true;
            }
            return false;
        }
    }

    public static abstract class Entry
    extends GuiListExtended.IGuiListEntry<Entry> {
        public abstract void save();
    }
}

