/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.config.values;

import com.bisecthosting.mods.bhmenu.ModRoot;
import com.bisecthosting.mods.bhmenu.config.PackConfigScreen;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public abstract class ConfigValueHolder<T, C extends ForgeConfigSpec.ConfigValue<T>> {
    private final CommentedFileConfig config;
    private final C configValue;
    private T value;

    public ConfigValueHolder(C configValue) {
        this.config = (CommentedFileConfig)ModRoot.get().modContainer.getModInfo().getModConfig();
        this.configValue = configValue;
        this.fetch();
    }

    public T value() {
        return this.value;
    }

    public void set(T value) {
        this.value = value;
    }

    public T getDefault() {
        return ((Supplier)ObfuscationReflectionHelper.getPrivateValue(ForgeConfigSpec.ConfigValue.class, this.configValue, (String)"defaultSupplier")).get();
    }

    public C config() {
        return this.configValue;
    }

    public void fetch() {
        this.value = this.configValue.get();
    }

    public void save() {
        if (!this.configValue.get().equals(this.value)) {
            this.config.set(this.configValue.getPath(), this.value);
            this.config.save();
            PackConfigScreen.hasChanged = true;
        }
    }

    public void onButtonPress() {
    }
}

