/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.modules.IModule;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.PublicServerList;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.ServerCreatorBanner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ModuleList {
    private List<IModule> modules = new ArrayList<IModule>();
    private Map<String, ForgeConfigSpec.BooleanValue> enableValues = new HashMap<String, ForgeConfigSpec.BooleanValue>();
    public final ServerCreatorBanner serverCreatorBanner = new ServerCreatorBanner();
    public final PublicServerList publicServerList = new PublicServerList();

    public List<IModule> getEnabled() {
        return this.modules.stream().filter(IModule::isEnabled).collect(Collectors.toList());
    }

    public ForgeConfigSpec.BooleanValue getEnabledValue(String moduleId) {
        return this.enableValues.get(moduleId);
    }

    public void initialize() {
        this.modules.add(this.serverCreatorBanner);
        this.modules.add(this.publicServerList);
    }

    public void configure(ForgeConfigSpec.Builder builder) {
        builder.push("modules");
        for (IModule module : this.modules) {
            builder.push(module.getId());
            this.enableValues.put(module.getId(), builder.define("enabled", true));
            module.buildConfigs(builder);
            builder.pop();
        }
        builder.pop();
    }

    private void load() {
        ModRef.LOGGER.info("Reloading Configs");
        for (IModule module : this.modules) {
            ForgeConfigSpec.BooleanValue enabled = this.enableValues.get(module.getId());
            if (module.isEnabled() == ((Boolean)enabled.get()).booleanValue()) continue;
            module.setEnabled((Boolean)enabled.get());
        }
    }

    public void onConfigReload(ModConfig.ConfigReloading event) {
        this.load();
    }

    public void onConfigLoad(ModConfig.Loading event) {
        this.load();
    }

    public List<IModule> getAll() {
        return Collections.unmodifiableList(this.modules);
    }
}

