/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.config.GlobalConfigs;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.PublicServerList;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.data.ServerListData;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen.PublicServersScreen;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Util;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.system.MemoryStack;

public class PublicServerSelectionList
extends GuiListExtended<Entry> {
    static final Logger LOGGER = LogManager.getLogger();
    static final ResourceLocation ICON_MISSING = new ResourceLocation("textures/misc/unknown_server.png");
    static final ResourceLocation ICON_OVERLAY_LOCATION = ModRef.res("textures/publicserverlist/gui/server_select_widgets.png");
    static final Supplier<String> LAST_PLAYED_LABEL = () -> I18n.func_135052_a((String)"modules.public_server_list.last_played_label", (Object[])new Object[0]);
    static final Supplier<String> PUBLIC_SERVERS_LABEL = () -> I18n.func_135052_a((String)"modules.public_server_list.public_servers_label", (Object[])new Object[0]);
    static final Supplier<String> CANT_RESOLVE_TEXT = () -> TextFormatting.DARK_RED + I18n.func_135052_a((String)"multiplayer.status.cannot_resolve", (Object[])new Object[0]);
    static final Supplier<String> CANT_CONNECT_TEXT = () -> TextFormatting.DARK_RED + I18n.func_135052_a((String)"multiplayer.status.cannot_connect", (Object[])new Object[0]);
    static final Supplier<String> INCOMPATIBLE_CLIENT_TOOLTIP = () -> I18n.func_135052_a((String)"multiplayer.status.client_out_of_date", (Object[])new Object[0]);
    static final Supplier<String> INCOMPATIBLE_SERVER_TOOLTIP = () -> I18n.func_135052_a((String)"multiplayer.status.server_out_of_date", (Object[])new Object[0]);
    static final Supplier<String> NO_CONNECTION_TOOLTIP = () -> I18n.func_135052_a((String)"multiplayer.status.no_connection", (Object[])new Object[0]);
    static final Supplier<String> PINGING_TOOLTIP = () -> I18n.func_135052_a((String)"multiplayer.status.pinging", (Object[])new Object[0]);
    static final Supplier<String> NO_SERVER = () -> I18n.func_135052_a((String)"modules.public_server_list.no_servers", (Object[])new Object[0]);
    static final Supplier<String> FIRST_TO_ADD_SERVER = () -> I18n.func_135052_a((String)"modules.public_server_list.first_server", (Object[])new Object[0]);
    private final ThreadPoolExecutor serverPingerThreadPool = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Public Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER)).build());
    private long ticks = 15L;
    private final PublicServersScreen screen;
    protected final List<ServerData> allServers = Lists.newArrayList();
    protected final List<ServerData> pingedServers = Lists.newArrayList();
    protected final List<ServerEntry> filteredEntries = Lists.newArrayList();
    private final Header lastPlayedHeader = new Header(LAST_PLAYED_LABEL.get());
    private final Header pingingHeader = new PingingHeader(PUBLIC_SERVERS_LABEL.get());
    private final Header noServersHeader = new Header(NO_SERVER.get(), FIRST_TO_ADD_SERVER.get());
    protected ServerEntry lastJoined;
    private boolean noServers;
    protected boolean filterPing;
    protected boolean filterPlayerCount;
    protected String filterName;

    public PublicServerSelectionList(PublicServersScreen parent, Minecraft minecraft, int width, int height, int y0, int y1, int itemHeight) {
        super(minecraft, width, height, y0, y1, itemHeight);
        this.screen = parent;
        this.noServersHeader.onClick(this.screen::openHowToPage);
        this.load();
    }

    protected void refreshEntries() {
        Entry lastEntry = this.getSelected();
        this.func_195086_c();
        if (this.lastJoined != null) {
            this.func_195085_a(this.lastPlayedHeader);
            this.func_195085_a(this.lastJoined);
        }
        this.func_195085_a(this.pingingHeader);
        if (this.noServers) {
            this.func_195085_a(this.noServersHeader);
        } else {
            this.filterEntries();
            this.filteredEntries.forEach(entry -> {
                this.func_195085_a((GuiListExtended.IGuiListEntry)entry);
                if (lastEntry instanceof ServerEntry && lastEntry != this.lastJoined) {
                    ServerEntry lastServerEntry = (ServerEntry)lastEntry;
                    if (((ServerEntry)lastServerEntry).serverData.field_78845_b.equals(((ServerEntry)entry).serverData.field_78845_b)) {
                        this.setSelected((ServerEntry)((Object)entry));
                    }
                }
            });
        }
        for (Entry entry2 : this.func_195074_b()) {
            if (!(entry2 instanceof ServerEntry) || entry2 != lastEntry) continue;
            this.setSelected((ServerEntry)entry2);
        }
        if (this.field_148169_q > (double)this.func_148135_f()) {
            this.field_148169_q = this.func_148135_f();
        }
    }

    public void filterEntries() {
        this.filteredEntries.clear();
        Stream<ServerEntry> filtering = Lists.newArrayList(this.pingedServers).stream().filter(s -> s.field_78844_e > 0L).map(server -> new ServerEntry(this.screen, (ServerData)server));
        if (!StringUtils.func_151246_b((String)this.filterName)) {
            filtering = filtering.filter(entry -> ((ServerEntry)entry).serverData.field_78847_a.toLowerCase(Locale.ROOT).contains(this.filterName.toLowerCase(Locale.ROOT)));
        }
        if (this.filterPlayerCount) {
            filtering = filtering.sorted((s1, s2) -> {
                int p1 = ((ServerEntry)s1).serverData.field_147412_i == null ? 0 : ((ServerEntry)s1).serverData.field_147412_i.split("\n").length;
                int p2 = ((ServerEntry)s2).serverData.field_147412_i == null ? 0 : ((ServerEntry)s2).serverData.field_147412_i.split("\n").length;
                return p2 - p1;
            });
        }
        if (this.filterPing) {
            filtering = filtering.sorted(Comparator.comparingLong(s -> ((ServerEntry)s).serverData.field_78844_e));
        }
        List filtered = filtering.collect(Collectors.toList());
        this.filteredEntries.addAll(filtered);
    }

    public void tick() {
        if (this.ticks++ % 20L == 0L) {
            int lastCount = this.allServers.size();
            this.allServers.removeIf(server -> {
                if (server.field_78843_d.equals(CANT_CONNECT_TEXT.get()) || server.field_78843_d.equals(CANT_RESOLVE_TEXT.get())) {
                    return true;
                }
                if (server.field_78844_e > 0L) {
                    this.pingedServers.add((ServerData)server);
                    return true;
                }
                return false;
            });
            if (lastCount != this.allServers.size()) {
                this.refreshEntries();
            }
        }
    }

    protected boolean func_148131_a(int entryId) {
        return this.field_148168_r == entryId;
    }

    public Entry getSelected() {
        if (this.field_148168_r >= this.func_195074_b().size()) {
            return null;
        }
        return (Entry)((Object)this.func_195074_b().get(this.field_148168_r));
    }

    public void setSelected(@Nullable ServerEntry entry) {
        this.func_195080_b(this.func_195074_b().indexOf((Object)entry));
        this.screen.onSelectedChange();
    }

    public boolean keyPressed(int p_99782_, int p_99783_, int p_99784_) {
        Entry entry = this.getSelected();
        return entry != null && entry.keyPressed(p_99782_, p_99783_, p_99784_) || super.keyPressed(p_99782_, p_99783_, p_99784_);
    }

    public void setNameFilter(String filter) {
        this.filterName = filter;
        this.refreshEntries();
    }

    public void togglePingSort() {
        this.filterPing = !this.filterPing;
        this.refreshEntries();
    }

    public void togglePlayerCountSort() {
        this.filterPlayerCount = !this.filterPlayerCount;
        this.refreshEntries();
    }

    public void updateOnlineServers(ServerListData servers) {
        if (servers.size() == 0) {
            this.noServers = true;
            this.refreshEntries();
            return;
        }
        this.noServers = false;
        this.pingedServers.clear();
        for (int i = 0; i < servers.size(); ++i) {
            ServerData server = servers.get(i);
            this.pingServer(server);
            this.allServers.add(server);
        }
        this.refreshEntries();
    }

    private void pingServer(ServerData server) {
        if (!server.field_78841_f) {
            server.field_78841_f = true;
            server.field_78844_e = -2L;
            server.field_78843_d = "";
            server.field_78846_c = "";
            this.serverPingerThreadPool.submit(() -> {
                try {
                    this.screen.getPinger().func_147224_a(server);
                }
                catch (UnknownHostException unknownhostexception) {
                    server.field_78844_e = -1L;
                    server.field_78843_d = CANT_RESOLVE_TEXT.get();
                }
                catch (Exception exception) {
                    server.field_78844_e = -1L;
                    server.field_78843_d = CANT_CONNECT_TEXT.get();
                }
            });
        }
    }

    protected int func_148137_d() {
        return this.field_148151_d - 6;
    }

    public int func_148139_c() {
        return (int)((float)this.screen.field_146294_l * 0.6f) - 10;
    }

    public void setLastJoined(ServerEntry entry) {
        this.lastJoined = new ServerEntry(this.screen, entry.serverData);
        this.save();
        this.refreshEntries();
    }

    public void save() {
        try {
            File configFolder = GlobalConfigs.MOD_CONFIG_FOLDER;
            File temp = File.createTempFile("last_joined", ".dat", configFolder);
            CompressedStreamTools.func_74793_a((NBTTagCompound)this.lastJoined.getServerData().func_78836_a(), (File)temp);
        }
        catch (Exception exception) {
            PublicServerList.LOGGER.error("Couldn't save last joined server", (Throwable)exception);
        }
    }

    public void load() {
        try {
            File configFolder = GlobalConfigs.MOD_CONFIG_FOLDER;
            NBTTagCompound tag = CompressedStreamTools.func_74797_a((File)new File(configFolder, "last_joined.dat"));
            if (tag != null) {
                ServerData serverdata = ServerData.func_78837_a((NBTTagCompound)tag);
                this.pingServer(serverdata);
                this.lastJoined = new ServerEntry(this.screen, serverdata);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't load last joined server", (Throwable)exception);
        }
    }

    public void stopPingingServer() {
        this.serverPingerThreadPool.shutdownNow();
    }

    public class ServerEntry
    extends Entry {
        private static final int ICON_WIDTH = 32;
        private static final int ICON_HEIGHT = 32;
        private static final int ICON_TEX_WIDTH = 64;
        private static final int ICON_TEX_HEIGHT = 64;
        private static final int ICON_OVERLAY_X_PLAY = 0;
        private static final int ICON_OVERLAY_X_ADD = 32;
        private static final int ICON_OVERLAY_Y_UNSELECTED = 0;
        private static final int ICON_OVERLAY_Y_SELECTED = 32;
        private final PublicServersScreen screen;
        private final Minecraft minecraft;
        private final ServerData serverData;
        private final ResourceLocation iconLocation;
        @Nullable
        private String lastIconB64;
        @Nullable
        private DynamicTexture icon;
        protected long lastClickTime;

        protected ServerEntry(PublicServersScreen screen, ServerData data) {
            this.screen = screen;
            this.serverData = data;
            this.minecraft = Minecraft.func_71410_x();
            this.iconLocation = new ResourceLocation("servers/" + Hashing.sha1().hashUnencodedChars((CharSequence)data.field_78845_b) + "/icon");
            ITextureObject abstracttexture = this.minecraft.func_110434_K().func_110581_b(this.iconLocation);
            if (abstracttexture instanceof DynamicTexture) {
                this.icon = (DynamicTexture)abstracttexture;
            }
        }

        public void func_194999_a(int width, int height, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            String pingTooltip;
            int signal;
            int mouseOverX = mouseX - this.func_195002_d();
            int mouseOverY = mouseY - this.func_195001_c();
            boolean lowerVersion = this.serverData.field_82821_f > 404;
            boolean higherVersion = this.serverData.field_82821_f < 404;
            boolean invalidVersion = lowerVersion || higherVersion;
            this.minecraft.field_71466_p.func_211126_b(this.serverData.field_78847_a, (float)(this.func_195002_d() + 32 + 3), (float)(this.func_195001_c() + 1), 0xFFFFFF);
            List list = this.minecraft.field_71466_p.func_78271_c(this.serverData.field_78843_d, width - 32 - 2);
            for (int i = 0; i < Math.min(list.size(), 2); ++i) {
                this.minecraft.field_71466_p.func_211126_b((String)list.get(i), (float)(this.func_195002_d() + 32 + 3), (float)(this.func_195001_c() + 12 + 9 * i), 0x808080);
            }
            String invalidVersionErrorText = invalidVersion ? TextFormatting.DARK_RED + this.serverData.field_82822_g : this.serverData.field_78846_c;
            int textWidth = this.minecraft.field_71466_p.func_78256_a(invalidVersionErrorText);
            this.minecraft.field_71466_p.func_211126_b(invalidVersionErrorText, (float)(this.func_195002_d() + width - textWidth - 15 - 2), (float)(this.func_195001_c() + 1), 0x808080);
            int signalTexOffset = 0;
            String playerList = null;
            if (invalidVersion) {
                signal = 5;
                pingTooltip = lowerVersion ? INCOMPATIBLE_CLIENT_TOOLTIP.get() : INCOMPATIBLE_SERVER_TOOLTIP.get();
                playerList = this.serverData.field_147412_i;
            } else if (this.serverData.field_78841_f && this.serverData.field_78844_e != -2L) {
                signal = this.serverData.field_78844_e < 0L ? 5 : (this.serverData.field_78844_e < 150L ? 0 : (this.serverData.field_78844_e < 300L ? 1 : (this.serverData.field_78844_e < 600L ? 2 : (this.serverData.field_78844_e < 1000L ? 3 : 4))));
                if (this.serverData.field_78844_e < 0L) {
                    pingTooltip = NO_CONNECTION_TOOLTIP.get();
                } else {
                    pingTooltip = this.serverData.field_78844_e + "ms";
                    playerList = this.serverData.field_147412_i;
                }
            } else {
                signalTexOffset = 1;
                signal = (int)(Util.func_211177_b() / 100L + (long)(this.field_195005_b * 2) & 7L);
                if (signal > 4) {
                    signal = 8 - signal;
                }
                pingTooltip = PINGING_TOOLTIP.get();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.minecraft.func_110434_K().func_110577_a(Gui.field_110324_m);
            Gui.func_146110_a((int)(this.func_195002_d() + width - 15), (int)this.func_195001_c(), (float)(signalTexOffset * 10), (float)(176 + signal * 8), (int)10, (int)8, (float)256.0f, (float)256.0f);
            String iconString = this.serverData.func_147409_e();
            if (iconString != null && !iconString.equals(this.lastIconB64)) {
                this.lastIconB64 = iconString;
                this.prepareServerIcon();
            }
            if (this.icon == null) {
                this.drawIcon(this.func_195002_d(), this.func_195001_c(), ICON_MISSING);
            } else {
                this.drawIcon(this.func_195002_d(), this.func_195001_c(), this.iconLocation);
            }
            if (mouseOverX >= width - 15 && mouseOverX <= width - 5 && mouseOverY >= 0 && mouseOverY <= 8) {
                this.screen.setTooltip(Collections.singletonList(pingTooltip));
            } else if (mouseOverX >= width - textWidth - 15 - 2 && mouseOverX <= width - 15 - 2 && mouseOverY >= 0 && mouseOverY <= 8) {
                this.screen.setTooltip(Collections.singletonList(playerList));
            }
            if (this.minecraft.field_71474_y.field_85185_A || hovered) {
                this.minecraft.func_110434_K().func_110577_a(ICON_OVERLAY_LOCATION);
                Gui.func_73734_a((int)this.func_195002_d(), (int)this.func_195001_c(), (int)(this.func_195002_d() + 32), (int)(this.func_195001_c() + 32), (int)-1601138544);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (this.canJoin()) {
                    if (mouseOverX > 16 && mouseOverX < 32) {
                        Gui.func_146110_a((int)this.func_195002_d(), (int)this.func_195001_c(), (float)0.0f, (float)32.0f, (int)32, (int)32, (float)64.0f, (float)64.0f);
                    } else {
                        Gui.func_146110_a((int)this.func_195002_d(), (int)this.func_195001_c(), (float)0.0f, (float)0.0f, (int)32, (int)32, (float)64.0f, (float)64.0f);
                    }
                }
                if (mouseOverX < 16) {
                    Gui.func_146110_a((int)this.func_195002_d(), (int)this.func_195001_c(), (float)32.0f, (float)32.0f, (int)32, (int)32, (float)64.0f, (float)64.0f);
                } else {
                    Gui.func_146110_a((int)this.func_195002_d(), (int)this.func_195001_c(), (float)32.0f, (float)0.0f, (int)32, (int)32, (float)64.0f, (float)64.0f);
                }
            }
        }

        private void prepareServerIcon() {
            if (this.serverData.func_147409_e() == null) {
                this.minecraft.func_110434_K().func_147645_c(this.iconLocation);
                this.icon.func_195414_e().close();
                this.icon = null;
            } else {
                try (MemoryStack memorystack = MemoryStack.stackPush();){
                    ByteBuffer bytebuffer = memorystack.UTF8((CharSequence)this.serverData.func_147409_e(), false);
                    ByteBuffer bytebuffer1 = Base64.getDecoder().decode(bytebuffer);
                    ByteBuffer bytebuffer2 = memorystack.malloc(bytebuffer1.remaining());
                    bytebuffer2.put(bytebuffer1);
                    bytebuffer2.rewind();
                    NativeImage nativeimage = NativeImage.func_195704_a((ByteBuffer)bytebuffer2);
                    Validate.validState((nativeimage.func_195702_a() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                    Validate.validState((nativeimage.func_195714_b() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                    if (this.icon == null) {
                        this.icon = new DynamicTexture(nativeimage);
                    } else {
                        this.icon.func_195415_a(nativeimage);
                        this.icon.func_110564_a();
                    }
                    this.minecraft.func_110434_K().func_110579_a(this.iconLocation, (ITextureObject)this.icon);
                }
                catch (Throwable throwable) {
                    LOGGER.error("Invalid icon for server {} ({})", (Object)this.serverData.field_78847_a, (Object)this.serverData.field_78845_b, (Object)throwable);
                    this.serverData.func_147407_a(null);
                }
            }
        }

        protected void drawIcon(int x, int y, ResourceLocation icon) {
            this.minecraft.func_110434_K().func_110577_a(icon);
            GlStateManager.func_179147_l();
            Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)32, (int)32, (float)32.0f, (float)32.0f);
            GlStateManager.func_179084_k();
        }

        protected boolean canJoin() {
            return true;
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            int serverIndex = PublicServerSelectionList.this.func_195074_b().indexOf((Object)this);
            double mouseOverX = mouseX - (double)PublicServerSelectionList.this.field_148152_e;
            if (mouseOverX <= 32.0) {
                if (mouseOverX > 16.0 && this.canJoin()) {
                    this.screen.setSelected(this);
                    this.screen.joinSelectedServer();
                    return true;
                }
                if (mouseOverX < 16.0) {
                    this.screen.setSelected(this);
                    this.screen.addSelectedServer();
                }
            }
            this.screen.setSelected(this);
            if (Util.func_211177_b() - this.lastClickTime < 250L) {
                this.screen.joinSelectedServer();
                return true;
            }
            this.lastClickTime = Util.func_211177_b();
            return false;
        }

        public ServerData getServerData() {
            return this.serverData;
        }
    }

    public class PingingHeader
    extends Header {
        public PingingHeader(String display) {
            super(display);
        }

        @Override
        public void func_194999_a(int width, int height, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            String s;
            super.func_194999_a(width, height, mouseX, mouseY, hovered, partialTicks);
            int drawY = this.func_195001_c() + height / 2 - 4;
            if (PublicServerSelectionList.this.allServers.isEmpty()) {
                return;
            }
            switch ((int)(Util.func_211177_b() / 300L % 4L)) {
                default: {
                    s = "O o o";
                    break;
                }
                case 1: 
                case 3: {
                    s = "o O o";
                    break;
                }
                case 2: {
                    s = "o o O";
                }
            }
            this.minecraft.field_71466_p.func_211126_b(s, (float)(PublicServerSelectionList.this.field_148152_e + width - this.minecraft.field_71466_p.func_78256_a(s) - 7), (float)drawY, 0xFFFFFF);
        }
    }

    public static class Header
    extends Entry {
        protected final Minecraft minecraft = Minecraft.func_71410_x();
        protected final String[] displays;
        private Runnable click;

        public Header(String ... displays) {
            this.displays = displays;
        }

        private Header onClick(Runnable onClick) {
            this.click = onClick;
            return this;
        }

        public void func_194999_a(int width, int height, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            int drawY = this.func_195001_c() + height / 2 - this.displays.length * this.minecraft.field_71466_p.field_78288_b / 2;
            for (String display : this.displays) {
                this.minecraft.field_71466_p.func_211126_b(display, (float)(this.func_195002_d() + (width - this.minecraft.field_71466_p.func_78256_a(display)) / 2), (float)drawY, 0xFFFFFF);
                drawY += this.minecraft.field_71466_p.field_78288_b;
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.click != null && this.isMouseOver(mouseX, mouseY) && button == 0) {
                this.click.run();
            }
            return false;
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return mouseX >= (double)this.func_195002_d() && mouseY >= (double)this.func_195001_c() && mouseX < (double)(this.func_195002_d() + this.field_195004_a.func_148139_c()) && mouseY < (double)(this.func_195001_c() + this.field_195004_a.func_148146_j());
        }
    }

    public static abstract class Entry
    extends GuiListExtended.IGuiListEntry<Entry> {
    }
}

