/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.servercreatorbanner;

import com.bisecthosting.mods.bhmenu.BHMultiplayerScreen;
import com.bisecthosting.mods.bhmenu.ModRoot;
import com.bisecthosting.mods.bhmenu.config.GlobalConfigs;
import com.bisecthosting.mods.bhmenu.config.components.text.TextConfigEditBox;
import com.bisecthosting.mods.bhmenu.config.components.toggle.BooleanConfigButton;
import com.bisecthosting.mods.bhmenu.config.lists.ModuleConfigList;
import com.bisecthosting.mods.bhmenu.config.values.BooleanHolder;
import com.bisecthosting.mods.bhmenu.config.values.StringHolder;
import com.bisecthosting.mods.bhmenu.modules.BaseModule;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerCreatorBanner
extends BaseModule {
    public static final Logger LOGGER = LogManager.getLogger();
    public ForgeConfigSpec.ConfigValue<String> title;
    public ForgeConfigSpec.ConfigValue<String> description;
    public ForgeConfigSpec.BooleanValue useLanguageFiles;

    public ServerCreatorBanner() {
        super("server_creator_banner");
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void replaceMultiplayerScreen(GuiScreenEvent.InitGuiEvent.Pre event) {
        if (event.getGui().getClass() == GuiMultiplayer.class && ModRoot.get().modules.serverCreatorBanner.isEnabled()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new BHMultiplayerScreen((GuiScreen)new GuiMainMenu()));
            event.setCanceled(true);
        }
    }

    @Override
    public void buildConfigs(ForgeConfigSpec.Builder builder) {
        builder.comment("Modpack Configs").push("pack");
        this.title = builder.comment("The title to display at the top of the entry.").define("title", (Object)"Need a server?");
        this.description = builder.comment("The description to display below the title.").define("description", (Object)"Click me to get your own server!");
        this.useLanguageFiles = builder.comment(new String[]{"Set this to true to use specific language translation keys.", "This requires a custom mod that adds resource files, such as OpenLoader.", "Use 'server_entry.title' key for the Title;", "Use 'server_entry.description' key for the Description."}).define("use_language_files", false);
        builder.pop().comment("User Configs").push("user");
        builder.pop();
    }

    @Override
    public boolean hasPackConfigs() {
        return true;
    }

    @Override
    public boolean hasUserConfigs() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void populatePackConfigs(ModuleConfigList configs, Consumer<ModuleConfigList.Entry> entries) {
        String text = I18n.func_135052_a((String)"modules.server_creator_banner.config.title", (Object[])new Object[0]);
        ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)GlobalConfigs.getSpec().getRaw(this.title.getPath());
        entries.accept(new ModuleConfigList.Entry(configs, valueSpec.getComment(), text, new TextConfigEditBox(0, new StringHolder(this.title), Minecraft.func_71410_x().field_71466_p, 0, 0, 0, 20, text)));
        text = I18n.func_135052_a((String)"modules.server_creator_banner.config.description", (Object[])new Object[0]);
        valueSpec = (ForgeConfigSpec.ValueSpec)GlobalConfigs.getSpec().getRaw(this.description.getPath());
        entries.accept(new ModuleConfigList.Entry(configs, valueSpec.getComment(), text, new TextConfigEditBox(1, new StringHolder(this.description), Minecraft.func_71410_x().field_71466_p, 0, 0, 0, 20, text)));
        text = I18n.func_135052_a((String)"modules.server_creator_banner.config.use_language_files", (Object[])new Object[0]);
        valueSpec = (ForgeConfigSpec.ValueSpec)GlobalConfigs.getSpec().getRaw(this.useLanguageFiles.getPath());
        entries.accept(new ModuleConfigList.Entry(configs, valueSpec.getComment(), text, new BooleanConfigButton(2, new BooleanHolder(this.useLanguageFiles), 0, 0, 0, 20)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void populateUserConfigs(ModuleConfigList configs, Consumer<ModuleConfigList.Entry> entries) {
    }

    public String getTitle() {
        return (Boolean)this.useLanguageFiles.get() != false ? I18n.func_135052_a((String)"server_entry.title", (Object[])new Object[0]) : (String)this.title.get();
    }

    public String getDescription() {
        return (Boolean)this.useLanguageFiles.get() != false ? I18n.func_135052_a((String)"server_entry.description", (Object[])new Object[0]) : (String)this.description.get();
    }
}

