/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.config.GlobalConfigs;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.OrderData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.ApiData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.JarGroupData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.BHOrderScreen;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.ProcessStep;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.RecommendJarStep;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.SelectJarStep;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.config.GuiSlider;

public class PlayerCountStep
extends ProcessStep {
    private final Supplier<String> question = () -> I18n.func_135052_a((String)"step.player_count.question", (Object[])new Object[0]);

    public PlayerCountStep(OrderData data) {
        super(data);
    }

    @Override
    public void init(final BHOrderScreen screen, Consumer<IGuiEventListener> children) {
        super.init(screen, children);
        children.accept((IGuiEventListener)new GuiSlider(1, (screen.field_146294_l - 250) / 2, screen.field_146295_m / 2 - 30, 250, 20, "", "", 0.0, 100.0, (double)this.orderData.playerCount, false, true, s -> {
            String stringVal;
            int val = s.getValueInt();
            s.field_146126_j = stringVal = val > 99 ? "99+" : String.valueOf(val);
            this.orderData.playerCount = val;
        }));
        children.accept((IGuiEventListener)new GuiButton(2, screen.field_146294_l / 2 - 50, screen.field_146295_m / 2 + 10, 100, 20, I18n.func_135052_a((String)"step.player_count.next", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                super.func_194829_a(mouseX, mouseY);
                JarGroupData.JarData recommendedJar = PlayerCountStep.getRecommendedJarData();
                if (recommendedJar == null) {
                    screen.setStep(new SelectJarStep(PlayerCountStep.this.orderData));
                } else {
                    screen.setStep(new RecommendJarStep(recommendedJar, PlayerCountStep.this.orderData));
                }
            }
        });
    }

    @Override
    public void render(BHOrderScreen screen, FontRenderer font, int mouseX, int mouseY, float partialTicks) {
        font.func_211126_b(this.question.get(), (float)(screen.field_146294_l - font.func_78256_a(this.question.get())) / 2.0f, (float)screen.field_146295_m / 2.0f - 50.0f, 0xFFFFFF);
    }

    @Override
    public void onClose(BHOrderScreen screen) {
        screen.field_146297_k.func_147108_a(screen.parent);
    }

    private static JarGroupData.JarData getRecommendedJarData() {
        if (((String)GlobalConfigs.packId.get()).isEmpty()) {
            return null;
        }
        JarGroupData.JarData recommendedJar = ApiData.AVAILABLE_JARS.get(GlobalConfigs.packId.get());
        if (recommendedJar == null) {
            ModRef.LOGGER.warn("Invalid pack id {}", GlobalConfigs.packId.get());
            return null;
        }
        return recommendedJar;
    }
}

