/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.client;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class DeferredDynamicTexture {
    private final ResourceLocation iconId;
    private final NativeImage rawImage;
    private DynamicTexture icon;
    private boolean registered;

    public DeferredDynamicTexture(@Nullable ResourceLocation iconId, @Nullable NativeImage image) {
        this.iconId = iconId;
        this.rawImage = image;
        if (iconId == null || this.rawImage == null) {
            return;
        }
        Minecraft.getInstance().execute(() -> {
            this.icon = new DynamicTexture(() -> ((ResourceLocation)iconId).toString(), this.rawImage);
            Minecraft.getInstance().getTextureManager().register(iconId, (AbstractTexture)this.icon);
            this.registered = true;
        });
    }

    public boolean isReady() {
        return this.iconId != null && this.icon != null && this.registered;
    }

    public Optional<DynamicTexture> getTexture() {
        return Optional.ofNullable(this.isReady() ? this.icon : null);
    }
}

