/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.config;

import com.bisecthosting.mods.bhmenu.ModRoot;
import com.bisecthosting.mods.bhmenu.utils.Singleton;
import java.io.File;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class GlobalConfigs {
    public static final Singleton<File> MOD_CONFIG_FOLDER = new Singleton<File>(() -> {
        File file = new File(Minecraft.getInstance().gameDirectory, "bhmenu");
        if (!file.mkdirs()) {
            throw new RuntimeException("Failed to create directory: " + file.getPath());
        }
        return file;
    });
    public static ModConfigSpec.ConfigValue<String> partnerId;
    public static ModConfigSpec.ConfigValue<String> packId;
    public static ModConfigSpec.BooleanValue packEditMode;
    private static ModConfigSpec spec;

    public static ModConfigSpec getSpec() {
        return spec;
    }

    public static void register() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        ModRoot.get().modules.configure(builder);
        partnerId = builder.comment(new String[]{"Your partner ID to use in during the ordering process.", "Without this you will not be credited for the purchases.", "(Your partner id is not the same as your referral link, please check your client area to find your partner id at https://www.bisecthosting.com/partners/console.php)."}).define("partner_id", (Object)"");
        packId = builder.comment(new String[]{"The id of this modpack.", "(This is BH internal pack id; Find the id here: https://www.bisecthosting.com/partners/console.php)"}).define("pack_id", (Object)"");
        packEditMode = builder.comment(new String[]{"Set this to false to disable pack config screen and enable user configs instead.", "This should always be done by the pack author once they are done with configuring the pack.", "To re-enable Pack Edit Mode, please edit the config file."}).define("pack_edit_mode", true);
        spec = builder.build();
        ModRoot.get().modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)spec);
    }

    public static void reloadConfigs() {
    }

    private static String defaultConfigName(ModConfig.Type type, String modId) {
        return String.format(Locale.ROOT, "%s-%s.toml", modId, type.extension());
    }
}

