/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.config;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.config.lists.ModuleConfigList;
import com.bisecthosting.mods.bhmenu.modules.IModule;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ModuleConfigScreen
extends Screen {
    private static final Component SAVE_TEXT = Component.translatable((String)"screen.config.save");
    private static final Component DISCARD_TEXT = Component.translatable((String)"screen.config.discard");
    private IModule module;
    private ModuleConfigList configList;
    private final BiConsumer<ModuleConfigList, Consumer<ModuleConfigList.Entry>> configPopulator;

    public ModuleConfigScreen(IModule module, BiConsumer<ModuleConfigList, Consumer<ModuleConfigList.Entry>> configPopulator) {
        super((Component)Component.translatable((String)("screen.config.modules." + module.getId() + ".name")));
        this.module = module;
        this.configPopulator = configPopulator;
    }

    protected void init() {
        super.init();
        if (this.configList == null) {
            this.configList = new ModuleConfigList(this, this.minecraft, this.width, this.height, 40, 30);
            this.configList.populateModuleConfigList(this.configPopulator);
        }
        this.configList.setWidth(this.width - 80);
        this.configList.setHeight(this.height - 80);
        this.configList.setX(40);
        this.configList.setY(40);
        this.addRenderableWidget((GuiEventListener)this.configList);
        Button saveButton = Button.builder((Component)SAVE_TEXT, this::saveAndExit).pos(this.width / 2 - 105, this.height - 30).width(100).build();
        Button discardButton = Button.builder((Component)DISCARD_TEXT, this::discardAndExit).pos(this.width / 2 + 5, this.height - 30).width(100).build();
        this.addRenderableWidget((GuiEventListener)saveButton);
        this.addRenderableWidget((GuiEventListener)discardButton);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)("screen.config.modules." + this.module.getId() + ".name")), this.width / 2, 10, 0xFFFFFF);
    }

    private void saveAndExit(Button button) {
        ModRef.LOGGER.info("Saving config changes");
        this.configList.saveAll();
        this.onClose();
    }

    private void discardAndExit(Button button) {
        ModRef.LOGGER.info("Discarding config changes");
        this.onClose();
    }

    public void onClose() {
        this.minecraft.popGuiLayer();
    }
}

