/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.config.GlobalConfigs;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.PublicServerList;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.data.ServerListData;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen.PublicServersScreen;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.StringUtil;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class PublicServerSelectionList
extends ObjectSelectionList<Entry> {
    static final Logger LOGGER = LogUtils.getLogger();
    static final ResourceLocation ICON_MISSING = ResourceLocation.withDefaultNamespace((String)"textures/misc/unknown_server.png");
    static final ResourceLocation ICON_OVERLAY_LOCATION = ModRef.res("textures/publicserverlist/gui/server_select_widgets.png");
    static final ResourceLocation INCOMPATIBLE_VERSION_ICON = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/server_list/incompatible.png");
    static final Component LAST_PLAYED_LABEL = Component.translatable((String)"modules.public_server_list.last_played_label");
    static final Component PUBLIC_SERVERS_LABEL = Component.translatable((String)"modules.public_server_list.public_servers_label");
    static final Component CANT_RESOLVE_TEXT = Component.translatable((String)"multiplayer.status.cannot_resolve").withStyle(ChatFormatting.DARK_RED);
    static final Component CANT_CONNECT_TEXT = Component.translatable((String)"multiplayer.status.cannot_connect").withStyle(ChatFormatting.DARK_RED);
    static final Component INCOMPATIBLE_TOOLTIP = Component.translatable((String)"multiplayer.status.incompatible");
    static final Component NO_CONNECTION_TOOLTIP = Component.translatable((String)"multiplayer.status.no_connection");
    static final Component PINGING_TOOLTIP = Component.translatable((String)"multiplayer.status.pinging");
    static final Component NO_SERVER = Component.translatable((String)"modules.public_server_list.no_servers");
    static final Component FIRST_TO_ADD_SERVER = Component.translatable((String)"modules.public_server_list.first_server");
    private final ThreadPoolExecutor serverPingerThreadPool = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Public Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER)).build());
    private long ticks = 15L;
    private final PublicServersScreen screen;
    protected final List<ServerData> allServers = Lists.newArrayList();
    protected final List<ServerData> pingedServers = Lists.newArrayList();
    protected final List<ServerEntry> filteredEntries = Lists.newArrayList();
    private final Header lastPlayedHeader = new Header(LAST_PLAYED_LABEL);
    private final Header pingingHeader = new PingingHeader(PUBLIC_SERVERS_LABEL);
    private final Header noServersHeader = new Header(NO_SERVER, FIRST_TO_ADD_SERVER);
    protected ServerEntry lastJoined;
    private boolean noServers;
    protected boolean filterPing;
    protected boolean filterPlayerCount;
    protected String filterName;

    public PublicServerSelectionList(PublicServersScreen parent, Minecraft minecraft, int width, int height, int y0, int itemHeight) {
        super(minecraft, width, height, y0, itemHeight);
        this.screen = parent;
        this.noServersHeader.onClick(this.screen::openHowToPage);
        this.load();
    }

    protected void refreshEntries() {
        Entry lastEntry = (Entry)this.getSelected();
        this.clearEntries();
        if (this.lastJoined != null) {
            this.addEntry((AbstractSelectionList.Entry)this.lastPlayedHeader);
            this.addEntry((AbstractSelectionList.Entry)this.lastJoined);
        }
        this.addEntry((AbstractSelectionList.Entry)this.pingingHeader);
        if (this.noServers) {
            this.addEntry((AbstractSelectionList.Entry)this.noServersHeader);
        } else {
            this.filterEntries();
            this.filteredEntries.forEach(entry -> {
                this.addEntry((AbstractSelectionList.Entry)entry);
                if (lastEntry instanceof ServerEntry) {
                    ServerEntry lastServerEntry = (ServerEntry)lastEntry;
                    if (lastServerEntry.serverData.ip.equals(entry.serverData.ip)) {
                        this.setSelected((ServerEntry)((Object)entry));
                    }
                }
            });
        }
        for (Entry entry2 : this.children()) {
            if (entry2 != lastEntry) continue;
            this.setSelected((AbstractSelectionList.Entry)entry2);
        }
    }

    public void filterEntries() {
        this.filteredEntries.clear();
        Stream<ServerEntry> filtering = Lists.newArrayList(this.pingedServers).stream().filter(s -> s.ping > 0L).map(server -> new ServerEntry(this.screen, (ServerData)server));
        Comparator<ServerEntry> sorting = (s1, s2) -> 0;
        if (!StringUtil.isNullOrEmpty((String)this.filterName)) {
            filtering = filtering.filter(entry -> entry.serverData.name.toLowerCase(Locale.ROOT).contains(this.filterName.toLowerCase(Locale.ROOT)));
        }
        if (this.filterPlayerCount) {
            sorting = sorting.thenComparing((s1, s2) -> {
                int p1 = s1.serverData.playerList == null ? 0 : s1.serverData.playerList.size();
                int p2 = s2.serverData.playerList == null ? 0 : s2.serverData.playerList.size();
                return p2 - p1;
            });
        }
        if (this.filterPing) {
            sorting = sorting.thenComparing(s -> s.serverData.ping);
        }
        filtering = filtering.sorted(sorting);
        List filtered = filtering.collect(Collectors.toList());
        this.filteredEntries.addAll(filtered);
    }

    public void tick() {
        if (this.ticks++ % 20L == 0L) {
            int lastCount = this.allServers.size();
            this.allServers.removeIf(server -> {
                if (server.motd.equals((Object)CANT_CONNECT_TEXT) || server.motd.equals((Object)CANT_RESOLVE_TEXT)) {
                    return true;
                }
                if (server.ping > 0L) {
                    this.pingedServers.add((ServerData)server);
                    return true;
                }
                return false;
            });
            if (lastCount != this.allServers.size()) {
                this.refreshEntries();
            }
        }
    }

    public void setSelected(@Nullable ServerEntry entry) {
        super.setSelected((AbstractSelectionList.Entry)entry);
        this.screen.onSelectedChange();
    }

    public boolean keyPressed(int p_99782_, int p_99783_, int p_99784_) {
        Entry entry = (Entry)this.getSelected();
        return entry != null && entry.keyPressed(p_99782_, p_99783_, p_99784_) || super.keyPressed(p_99782_, p_99783_, p_99784_);
    }

    public void setNameFilter(String filter) {
        this.filterName = filter;
        this.refreshEntries();
    }

    public void togglePingSort() {
        this.filterPing = !this.filterPing;
        this.refreshEntries();
    }

    public void togglePlayerCountSort() {
        this.filterPlayerCount = !this.filterPlayerCount;
        this.refreshEntries();
    }

    public void updateOnlineServers(ServerListData servers) {
        if (servers.size() == 0) {
            this.noServers = true;
            this.refreshEntries();
            return;
        }
        this.noServers = false;
        this.pingedServers.clear();
        for (int i = 0; i < servers.size(); ++i) {
            ServerData server = servers.get(i);
            this.pingServer(server);
            this.allServers.add(server);
        }
        this.refreshEntries();
    }

    private void pingServer(ServerData server) {
        if (server.state() != ServerData.State.SUCCESSFUL) {
            server.setState(ServerData.State.SUCCESSFUL);
            server.ping = -2L;
            server.motd = CommonComponents.EMPTY;
            server.status = CommonComponents.EMPTY;
            this.serverPingerThreadPool.submit(() -> {
                try {
                    this.screen.getPinger().pingServer(server, () -> {}, () -> {});
                }
                catch (UnknownHostException unknownhostexception) {
                    server.ping = -1L;
                    server.motd = CANT_RESOLVE_TEXT;
                }
                catch (Exception exception) {
                    server.ping = -1L;
                    server.motd = CANT_CONNECT_TEXT;
                }
            });
        }
    }

    protected int scrollBarX() {
        return this.getRight() - 4;
    }

    public int getRowWidth() {
        return (int)((float)this.screen.width * 0.6f) - 8;
    }

    public boolean isFocused() {
        return this.screen.getFocused() == this;
    }

    public void setLastJoined(ServerEntry entry) {
        this.lastJoined = new ServerEntry(this.screen, entry.serverData);
        this.save();
        this.refreshEntries();
    }

    public void save() {
        try {
            File configFolder = GlobalConfigs.MOD_CONFIG_FOLDER.get();
            File temp = File.createTempFile("last_joined", ".dat", configFolder);
            NbtIo.write((CompoundTag)this.lastJoined.getServerData().write(), (Path)temp.toPath());
            File old = new File(configFolder, "last_joined.dat_old");
            File current = new File(configFolder, "last_joined.dat");
            Util.safeReplaceFile((Path)current.toPath(), (Path)temp.toPath(), (Path)old.toPath());
        }
        catch (Exception exception) {
            PublicServerList.LOGGER.error("Couldn't save last joined server", (Throwable)exception);
        }
    }

    public void load() {
        try {
            File configFolder = GlobalConfigs.MOD_CONFIG_FOLDER.get();
            CompoundTag tag = NbtIo.read((Path)new File(configFolder, "last_joined.dat").toPath());
            if (tag != null) {
                ServerData serverdata = ServerData.read((CompoundTag)tag);
                this.pingServer(serverdata);
                this.lastJoined = new ServerEntry(this.screen, serverdata);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't load last joined server", (Throwable)exception);
        }
    }

    public void stopPingingServer() {
        this.serverPingerThreadPool.shutdownNow();
    }

    public static class Header
    extends Entry {
        protected final Minecraft minecraft = Minecraft.getInstance();
        protected final Component[] displays;
        protected MutableComponent allDisplays;
        private Runnable click;

        public Header(Component ... displays) {
            this.displays = displays;
            this.allDisplays = displays[0].copy();
            for (int i = 1; i < displays.length; ++i) {
                this.allDisplays.append(displays[i]);
            }
        }

        private Header onClick(Runnable onClick) {
            this.click = onClick;
            return this;
        }

        public void render(GuiGraphics graphics, int index, int top, int left, int width, int innerHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            int n = top + innerHeight / 2;
            int n2 = this.displays.length;
            Objects.requireNonNull(this.minecraft.font);
            int drawY = n - n2 * 9 / 2;
            for (Component display : this.displays) {
                graphics.drawString(this.minecraft.font, display, left + (width - this.minecraft.font.width((FormattedText)display)) / 2, drawY, 0xFFFFFF);
                Objects.requireNonNull(this.minecraft.font);
                drawY += 9;
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.click != null && this.isMouseOver(mouseX, mouseY) && button == 0) {
                this.click.run();
            }
            return false;
        }

        public Component getNarration() {
            return this.allDisplays;
        }
    }

    public class PingingHeader
    extends Header {
        public PingingHeader(Component display) {
            super(display);
        }

        @Override
        public void render(GuiGraphics graphics, int index, int top, int left, int width, int innerHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            super.render(graphics, index, top, left, width, innerHeight, mouseX, mouseY, hovered, delta);
            int drawY = top + innerHeight / 2 - 4;
            if (PublicServerSelectionList.this.allServers.isEmpty()) {
                return;
            }
            String s = switch ((int)(Util.getMillis() / 300L % 4L)) {
                default -> "O o o";
                case 1, 3 -> "o O o";
                case 2 -> "o o O";
            };
            graphics.drawString(this.minecraft.font, s, left + width - this.minecraft.font.width(s) - 7, drawY, 0xFFFFFF);
        }
    }

    public static abstract class Entry
    extends ObjectSelectionList.Entry<Entry> {
    }

    public class ServerEntry
    extends Entry {
        private static final int ICON_WIDTH = 32;
        private static final int ICON_HEIGHT = 32;
        private static final int ICON_TEX_WIDTH = 64;
        private static final int ICON_TEX_HEIGHT = 64;
        private static final int ICON_OVERLAY_X_PLAY = 0;
        private static final int ICON_OVERLAY_X_ADD = 32;
        private static final int ICON_OVERLAY_Y_UNSELECTED = 0;
        private static final int ICON_OVERLAY_Y_SELECTED = 32;
        private final PublicServersScreen screen;
        private final Minecraft minecraft;
        private final ServerData serverData;
        private final ResourceLocation iconLocation;
        @Nullable
        private byte[] lastIconBytes;
        @Nullable
        private DynamicTexture icon;
        protected long lastClickTime;

        protected ServerEntry(PublicServersScreen screen, ServerData data) {
            this.screen = screen;
            this.serverData = data;
            this.minecraft = Minecraft.getInstance();
            this.iconLocation = ResourceLocation.withDefaultNamespace((String)("servers/" + String.valueOf(Hashing.sha1().hashUnencodedChars((CharSequence)data.ip)) + "/icon"));
            AbstractTexture abstracttexture = this.minecraft.getTextureManager().getTexture(this.iconLocation);
            if (abstracttexture instanceof DynamicTexture) {
                DynamicTexture texture;
                this.icon = texture = (DynamicTexture)abstracttexture;
            }
        }

        public void render(GuiGraphics graphics, int index, int top, int left, int width, int innerHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            List playerList;
            Component pingTooltip;
            int mouseOverX = mouseX - left;
            int mouseOverY = mouseY - top;
            boolean invalidVersion = this.serverData.protocol != SharedConstants.getCurrentVersion().getProtocolVersion();
            graphics.drawString(this.minecraft.font, this.serverData.name, left + 32 + 3, top + 1, 0xFFFFFF);
            List list = this.minecraft.font.split((FormattedText)this.serverData.motd, width - 32 - 2);
            for (int i = 0; i < Math.min(list.size(), 2); ++i) {
                graphics.drawString(this.minecraft.font, (FormattedCharSequence)list.get(i), left + 32 + 3, top + 12 + 9 * i, 0x808080);
            }
            Component invalidVersionErrorText = invalidVersion ? this.serverData.version.copy().withStyle(ChatFormatting.RED) : this.serverData.status;
            int textWidth = this.minecraft.font.width((FormattedText)invalidVersionErrorText);
            graphics.drawString(this.minecraft.font, invalidVersionErrorText, left + width - textWidth - 15 - 2, top + 1, 0x808080);
            boolean signalTexOffset = false;
            if (invalidVersion) {
                int signal = 5;
                pingTooltip = INCOMPATIBLE_TOOLTIP;
                playerList = this.serverData.playerList;
            } else if (this.serverData.state() == ServerData.State.SUCCESSFUL && this.serverData.ping != -2L) {
                if (this.serverData.ping < 0L) {
                    int signal = 5;
                } else if (this.serverData.ping < 150L) {
                    boolean signal = false;
                } else if (this.serverData.ping < 300L) {
                    boolean signal = true;
                } else if (this.serverData.ping < 600L) {
                    int signal = 2;
                } else if (this.serverData.ping < 1000L) {
                    int signal = 3;
                } else {
                    int signal = 4;
                }
                if (this.serverData.ping < 0L) {
                    pingTooltip = NO_CONNECTION_TOOLTIP;
                    playerList = Collections.emptyList();
                } else {
                    pingTooltip = Component.translatable((String)"multiplayer.status.ping", (Object[])new Object[]{this.serverData.ping});
                    playerList = this.serverData.playerList;
                }
            } else {
                signalTexOffset = true;
                int signal = (int)(Util.getMillis() / 100L + (long)(index * 2) & 7L);
                if (signal > 4) {
                    signal = 8 - signal;
                }
                pingTooltip = PINGING_TOOLTIP;
                playerList = Collections.emptyList();
            }
            graphics.blit(RenderType::guiTextured, INCOMPATIBLE_VERSION_ICON, left + width - 15, top, 0.0f, 0.0f, 10, 8, 10, 8);
            byte[] iconBytes = this.serverData.getIconBytes();
            if (!Arrays.equals(iconBytes, this.lastIconBytes)) {
                if (this.uploadServerIcon(iconBytes)) {
                    this.lastIconBytes = iconBytes;
                } else {
                    this.serverData.setIconBytes(null);
                }
            }
            if (this.icon == null) {
                this.drawIcon(graphics, left, top, ICON_MISSING);
            } else {
                this.drawIcon(graphics, left, top, this.iconLocation);
            }
            if (mouseOverX >= width - 15 && mouseOverX <= width - 5 && mouseOverY >= 0 && mouseOverY <= 8) {
                this.screen.setTooltip(Collections.singletonList(pingTooltip));
            } else if (mouseOverX >= width - textWidth - 15 - 2 && mouseOverX <= width - 15 - 2 && mouseOverY >= 0 && mouseOverY <= 8) {
                this.screen.setTooltip(playerList);
            }
            if (((Boolean)this.minecraft.options.touchscreen().get()).booleanValue() || hovered) {
                graphics.fill(left, top, left + 32, top + 32, -1601138544);
                if (this.canJoin()) {
                    if (mouseOverX > 16 && mouseOverX < 32) {
                        graphics.blit(RenderType::guiTextured, ICON_OVERLAY_LOCATION, left, top, 0.0f, 32.0f, 32, 32, 64, 64);
                    } else {
                        graphics.blit(RenderType::guiTextured, ICON_OVERLAY_LOCATION, left, top, 0.0f, 0.0f, 32, 32, 64, 64);
                    }
                }
                if (mouseOverX < 16) {
                    graphics.blit(RenderType::guiTextured, ICON_OVERLAY_LOCATION, left, top, 32.0f, 32.0f, 32, 32, 64, 64);
                } else {
                    graphics.blit(RenderType::guiTextured, ICON_OVERLAY_LOCATION, left, top, 32.0f, 0.0f, 32, 32, 64, 64);
                }
            }
        }

        protected void drawIcon(GuiGraphics graphics, int mouseX, int mouseY, ResourceLocation texture) {
            graphics.blit(RenderType::guiTextured, texture, mouseX, mouseY, 0.0f, 0.0f, 32, 32, 32, 32);
        }

        protected boolean canJoin() {
            return true;
        }

        private boolean uploadServerIcon(@Nullable byte[] iconBytes) {
            if (iconBytes == null) {
                this.minecraft.getTextureManager().release(this.iconLocation);
                if (this.icon != null && this.icon.getPixels() != null) {
                    this.icon.getPixels().close();
                }
                this.icon = null;
            } else {
                try {
                    NativeImage nativeimage = NativeImage.read((byte[])iconBytes);
                    Validate.validState((nativeimage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                    Validate.validState((nativeimage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                    if (this.icon == null) {
                        this.icon = new DynamicTexture(() -> this.serverData.name, nativeimage);
                    } else {
                        this.icon.setPixels(nativeimage);
                        this.icon.upload();
                    }
                    this.minecraft.getTextureManager().register(this.iconLocation, (AbstractTexture)this.icon);
                }
                catch (Throwable throwable) {
                    LOGGER.error("Invalid icon for server {} ({})", new Object[]{this.serverData.name, this.serverData.ip, throwable});
                    return false;
                }
            }
            return true;
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            int serverIndex = PublicServerSelectionList.this.children().indexOf((Object)this);
            double mouseOverX = mouseX - (double)PublicServerSelectionList.this.getRowLeft();
            if (mouseOverX <= 32.0) {
                if (mouseOverX > 16.0 && this.canJoin()) {
                    this.screen.setSelected(this);
                    this.screen.joinSelectedServer();
                    return true;
                }
                if (mouseOverX < 16.0) {
                    this.screen.setSelected(this);
                    this.screen.addSelectedServer();
                }
            }
            this.screen.setSelected(this);
            if (Util.getMillis() - this.lastClickTime < 250L) {
                this.screen.joinSelectedServer();
                return true;
            }
            this.lastClickTime = Util.getMillis();
            return false;
        }

        public ServerData getServerData() {
            return this.serverData;
        }

        public Component getNarration() {
            return Component.translatable((String)"narrator.select", (Object[])new Object[]{this.serverData.name});
        }
    }
}

