/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens;

import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.OrderData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api.ApiData;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.LoadPlansStep;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.PlayerCountStep;
import com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.screens.steps.ProcessStep;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class BHOrderScreen
extends Screen {
    public final Screen parent;
    private final OrderData orderData = new OrderData();
    private ProcessStep currentStep;
    private CompletableFuture<Void> task;
    private boolean firstTick = true;

    public BHOrderScreen(Screen parent) {
        super((Component)Component.translatable((String)"bhorder.title"));
        this.parent = parent;
    }

    protected void init() {
        super.init();
        if (this.currentStep != null) {
            this.currentStep.init(this, this::addChild);
        }
    }

    public void addChild(GuiEventListener child) {
        if (child instanceof Renderable) {
            this.addRenderableWidget((GuiEventListener)((Renderable)((GuiEventListener)((NarratableEntry)child))));
        } else {
            this.addWidget((GuiEventListener)((NarratableEntry)child));
        }
    }

    public void tick() {
        if (this.firstTick) {
            this.task = ApiData.reloadData().whenComplete((v, e) -> {
                if (e == null) {
                    this.setStep(new PlayerCountStep(this.orderData));
                }
            });
            this.setStep(new LoadPlansStep(this.task, this.orderData));
            this.firstTick = false;
        } else if (this.currentStep != null) {
            this.currentStep.tick(this);
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
        super.render(graphics, mouseX, mouseY, pTicks);
        if (this.currentStep != null) {
            this.currentStep.render(this, this.font, graphics, mouseX, mouseY, pTicks);
        }
        if (this.currentStep != null) {
            this.currentStep.renderLast(this, this.font, graphics, mouseX, mouseY, pTicks);
        }
    }

    public void setStep(ProcessStep step) {
        this.clearWidgets();
        this.currentStep = step;
        if (this.currentStep != null) {
            this.currentStep.init(this, this::addChild);
        }
    }

    public void onClose() {
        if (this.currentStep != null) {
            this.currentStep.onClose(this);
        } else {
            this.minecraft.setScreen(this.parent);
        }
    }
}

