/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.config;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.config.ConfigValue;
import com.bisecthosting.mods.bhmenu.config.values.BooleanValue;
import com.bisecthosting.mods.bhmenu.config.values.IntValue;
import com.bisecthosting.mods.bhmenu.config.values.StringValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class Config {
    private final Properties configProperties;
    private final File configFile;
    private final StringBuilder comments;
    private final List<ConfigValue<?>> values;

    public Config(Properties configProperties, File configFile) {
        this.configProperties = configProperties;
        this.configFile = configFile;
        this.comments = new StringBuilder();
        this.values = new ArrayList();
    }

    public StringBuilder getComments() {
        return this.comments;
    }

    public IntValue defineInt(String key, int defaultValue, String ... comments) {
        IntValue value = new IntValue(this.configProperties, key, defaultValue, comments);
        return this.define(key, value, comments);
    }

    public StringValue defineString(String key, String defaultValue, String ... comments) {
        StringValue value = new StringValue(this.configProperties, key, defaultValue, new String[0]);
        return this.define(key, value, comments);
    }

    public BooleanValue defineBoolean(String key, boolean defaultValue, String ... comments) {
        BooleanValue value = new BooleanValue(this.configProperties, key, defaultValue, new String[0]);
        return this.define(key, value, comments);
    }

    private <T extends ConfigValue<?>> T define(String key, T configValue, String ... comments) {
        for (String comment : comments) {
            this.comments.append(key).append(" - ").append(comment).append('\n');
        }
        this.values.add(configValue);
        return configValue;
    }

    public void save() {
        this.values.stream().filter(ConfigValue::hasChanged).forEachOrdered(value -> {
            value.writeValue();
            value.clearChanged();
        });
        try (FileOutputStream stream = new FileOutputStream(this.configFile);){
            this.configProperties.store(stream, this.comments.toString());
        }
        catch (IOException e) {
            ModRef.LOGGER.warn("Could not store property file '" + this.configFile.getAbsolutePath() + "'", (Throwable)e);
        }
    }

    public void load() {
        if (this.configFile.exists()) {
            try (FileInputStream stream = new FileInputStream(this.configFile);){
                this.configProperties.load(stream);
                this.values.forEach(ConfigValue::fetch);
            }
            catch (IOException e) {
                ModRef.LOGGER.warn("Could not read property file '" + this.configFile.getAbsolutePath() + "'", (Throwable)e);
            }
        }
    }
}

