/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.ModRoot;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.PublicServerList;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.data.ServerListData;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen.PublicServersScreen;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import io.netty.util.internal.StringUtil;
import java.io.File;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Stream;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_124;
import net.minecraft.class_140;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_642;
import net.minecraft.class_757;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class PublicServerSelectionList
extends class_4280<Entry> {
    static final Logger LOGGER = LogUtils.getLogger();
    static final class_2960 ICON_MISSING = new class_2960("textures/misc/unknown_server.png");
    static final class_2960 ICON_OVERLAY_LOCATION = ModRef.res("textures/publicserverlist/gui/server_select_widgets.png");
    static final class_2561 LAST_PLAYED_LABEL = class_2561.method_43471((String)"modules.public_server_list.last_played_label");
    static final class_2561 PUBLIC_SERVERS_LABEL = class_2561.method_43471((String)"modules.public_server_list.public_servers_label");
    static final class_2561 CANT_RESOLVE_TEXT = class_2561.method_43471((String)"multiplayer.status.cannot_resolve").method_27692(class_124.field_1079);
    static final class_2561 CANT_CONNECT_TEXT = class_2561.method_43471((String)"multiplayer.status.cannot_connect").method_27692(class_124.field_1079);
    static final class_2561 INCOMPATIBLE_TOOLTIP = class_2561.method_43471((String)"multiplayer.status.incompatible");
    static final class_2561 NO_CONNECTION_TOOLTIP = class_2561.method_43471((String)"multiplayer.status.no_connection");
    static final class_2561 PINGING_TOOLTIP = class_2561.method_43471((String)"multiplayer.status.pinging");
    static final class_2561 NO_SERVER = class_2561.method_43471((String)"modules.public_server_list.no_servers");
    static final class_2561 FIRST_TO_ADD_SERVER = class_2561.method_43471((String)"modules.public_server_list.first_server");
    private final ThreadPoolExecutor serverPingerThreadPool = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Public Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new class_140(LOGGER)).build());
    private final PublicServersScreen screen;
    private long ticks = 15L;
    protected final List<class_642> allServers = Lists.newArrayList();
    protected final List<class_642> pingedServers = Lists.newArrayList();
    protected final List<ServerEntry> filteredEntries = Lists.newArrayList();
    private final Header lastPlayedHeader = new Header(LAST_PLAYED_LABEL);
    private final Header pingingHeader = new PingingHeader(PUBLIC_SERVERS_LABEL);
    private final Header noServersHeader = new Header(NO_SERVER, FIRST_TO_ADD_SERVER);
    protected ServerEntry lastJoined;
    private boolean noServers;
    protected boolean filterPing;
    protected boolean filterPlayerCount;
    protected String filterName;

    public PublicServerSelectionList(PublicServersScreen parent, class_310 minecraft, int width, int height, int y0, int y1, int itemHeight) {
        super(minecraft, width, height, y0, y1, itemHeight);
        this.screen = parent;
        this.noServersHeader.onClick(this.screen::openHowToPage);
        this.load();
    }

    protected void refreshEntries() {
        Entry lastEntry = (Entry)this.method_25334();
        this.method_25339();
        if (this.lastJoined != null) {
            this.method_25321((class_350.class_351)this.lastPlayedHeader);
            this.method_25321((class_350.class_351)this.lastJoined);
        }
        this.method_25321((class_350.class_351)this.pingingHeader);
        if (this.noServers) {
            this.method_25321((class_350.class_351)this.noServersHeader);
        } else {
            this.filterEntries();
            this.filteredEntries.forEach(entry -> {
                this.method_25321((class_350.class_351)entry);
                if (lastEntry instanceof ServerEntry) {
                    ServerEntry lastServerEntry = (ServerEntry)lastEntry;
                    if (lastServerEntry.serverData.field_3761.equals(entry.serverData.field_3761)) {
                        this.setSelected((ServerEntry)((Object)entry));
                    }
                }
            });
        }
        for (Entry entry2 : this.method_25396()) {
            if (entry2 != lastEntry) continue;
            this.method_25313((class_350.class_351)entry2);
        }
        if (this.method_25341() > (double)this.method_25331()) {
            this.method_25307(this.method_25331());
        }
    }

    public void filterEntries() {
        this.filteredEntries.clear();
        Stream<ServerEntry> filtering = Lists.newArrayList(this.pingedServers).stream().filter(s -> s.field_3758 > 0L).map(server -> new ServerEntry(this.screen, (class_642)server));
        Comparator<ServerEntry> comparator = (s1, s2) -> 0;
        if (!StringUtil.isNullOrEmpty((String)this.filterName)) {
            filtering = filtering.filter(entry -> entry.serverData.field_3752.toLowerCase(Locale.ROOT).contains(this.filterName.toLowerCase(Locale.ROOT)));
        }
        if (this.filterPlayerCount) {
            comparator = comparator.thenComparing((s1, s2) -> {
                int p1 = s1.serverData.field_3762 == null ? 0 : s1.serverData.field_3762.size();
                int p2 = s2.serverData.field_3762 == null ? 0 : s2.serverData.field_3762.size();
                return p2 - p1;
            });
        }
        if (this.filterPing) {
            comparator = comparator.thenComparingLong(s -> s.serverData.field_3758);
        }
        List<ServerEntry> filtered = filtering.sorted(comparator).toList();
        this.filteredEntries.addAll(filtered);
    }

    public void tick() {
        if (this.ticks++ % 20L == 0L) {
            int lastCount = this.allServers.size();
            this.allServers.removeIf(server -> {
                if (server.field_3757.equals(CANT_CONNECT_TEXT) || server.field_3757.equals(CANT_RESOLVE_TEXT)) {
                    return true;
                }
                if (server.field_3758 > 0L) {
                    this.pingedServers.add((class_642)server);
                    return true;
                }
                return false;
            });
            if (lastCount != this.allServers.size()) {
                this.refreshEntries();
            }
        }
    }

    public void setSelected(ServerEntry entry) {
        super.method_25313((class_350.class_351)entry);
        this.screen.onSelectedChange();
    }

    public boolean method_25404(int p_99782_, int p_99783_, int p_99784_) {
        Entry entry = (Entry)this.method_25334();
        return entry != null && entry.method_25404(p_99782_, p_99783_, p_99784_) || super.method_25404(p_99782_, p_99783_, p_99784_);
    }

    public void setNameFilter(String filter) {
        this.filterName = filter;
        this.refreshEntries();
    }

    public void togglePingSort() {
        this.filterPing = !this.filterPing;
        this.refreshEntries();
    }

    public void togglePlayerCountSort() {
        this.filterPlayerCount = !this.filterPlayerCount;
        this.refreshEntries();
    }

    public void updateOnlineServers(ServerListData servers) {
        if (servers.size() == 0) {
            this.noServers = true;
            this.refreshEntries();
            return;
        }
        this.noServers = false;
        this.pingedServers.clear();
        for (int i = 0; i < servers.size(); ++i) {
            class_642 server = servers.get(i);
            this.pingServer(server);
            this.allServers.add(server);
        }
        this.refreshEntries();
    }

    private void pingServer(class_642 server) {
        if (!server.field_3754) {
            server.field_3754 = true;
            server.field_3758 = -2L;
            server.field_3757 = class_5244.field_39003;
            server.field_3753 = class_5244.field_39003;
            this.serverPingerThreadPool.submit(() -> {
                try {
                    this.screen.getPinger().method_3003(server, () -> {});
                }
                catch (UnknownHostException unknownhostexception) {
                    server.field_3758 = -1L;
                    server.field_3757 = CANT_RESOLVE_TEXT;
                }
                catch (Exception exception) {
                    server.field_3758 = -1L;
                    server.field_3757 = CANT_CONNECT_TEXT;
                }
            });
        }
    }

    protected int method_25329() {
        return this.field_19087 - 4;
    }

    public int method_25322() {
        return (int)((float)this.screen.field_22789 * 0.6f) - 8;
    }

    public boolean method_25370() {
        return this.screen.method_25399() == this;
    }

    public void setLastJoined(ServerEntry entry) {
        this.lastJoined = new ServerEntry(this.screen, entry.serverData);
        this.save();
        this.refreshEntries();
    }

    public void save() {
        File configDirectory = ModRoot.get().configs.configDirectory;
        try {
            File temp = File.createTempFile("last_joined", ".dat", configDirectory);
            class_2507.method_10630((class_2487)this.lastJoined.getServerInfo().method_2992(), (File)temp);
            File old = new File(configDirectory, "last_joined.dat_old");
            File current = new File(configDirectory, "last_joined.dat");
            class_156.method_27760((File)current, (File)temp, (File)old);
        }
        catch (Exception exception) {
            PublicServerList.LOGGER.error("Couldn't save last joined server", (Throwable)exception);
        }
    }

    public void load() {
        File configDirectory = ModRoot.get().configs.configDirectory;
        try {
            class_2487 tag = class_2507.method_10633((File)new File(configDirectory, "last_joined.dat"));
            if (tag != null) {
                class_642 serverdata = class_642.method_2993((class_2487)tag);
                this.pingServer(serverdata);
                this.lastJoined = new ServerEntry(this.screen, serverdata);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't load last joined server", (Throwable)exception);
        }
    }

    public void stopPingingServer() {
        this.serverPingerThreadPool.shutdownNow();
    }

    public static class Header
    extends Entry {
        protected final class_310 minecraft = class_310.method_1551();
        protected final class_2561[] displays;
        protected class_5250 allDisplays;
        private Runnable click;

        public Header(class_2561 ... displays) {
            this.displays = displays;
            this.allDisplays = displays[0].method_27661();
            for (int i = 1; i < displays.length; ++i) {
                this.allDisplays.method_10852(displays[i]);
            }
        }

        private Header onClick(Runnable onClick) {
            this.click = onClick;
            return this;
        }

        public void method_25343(class_4587 matrix, int index, int top, int left, int width, int innerHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            int n = top + innerHeight / 2;
            int n2 = this.displays.length;
            Objects.requireNonNull(this.minecraft.field_1772);
            int drawY = n - n2 * 9 / 2;
            for (class_2561 display : this.displays) {
                this.minecraft.field_1772.method_30883(matrix, display, (float)(left + (width - this.minecraft.field_1772.method_27525((class_5348)display)) / 2), (float)drawY, 0xFFFFFF);
                Objects.requireNonNull(this.minecraft.field_1772);
                drawY += 9;
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.click != null && this.method_25405(mouseX, mouseY) && button == 0) {
                this.click.run();
            }
            return false;
        }

        public class_2561 method_37006() {
            return this.allDisplays;
        }
    }

    public class PingingHeader
    extends Header {
        public PingingHeader(class_2561 display) {
            super(display);
        }

        @Override
        public void method_25343(class_4587 matrix, int index, int top, int left, int width, int innerHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            super.method_25343(matrix, index, top, left, width, innerHeight, mouseX, mouseY, hovered, delta);
            int drawY = top + innerHeight / 2 - 4;
            if (PublicServerSelectionList.this.allServers.isEmpty()) {
                return;
            }
            String s = switch ((int)(class_156.method_658() / 300L % 4L)) {
                default -> "O o o";
                case 1, 3 -> "o O o";
                case 2 -> "o o O";
            };
            this.minecraft.field_1772.method_1729(matrix, s, (float)(left + width - this.minecraft.field_1772.method_1727(s) - 7), (float)drawY, 0xFFFFFF);
        }
    }

    public static abstract class Entry
    extends class_4280.class_4281<Entry> {
    }

    public class ServerEntry
    extends Entry {
        private static final int ICON_WIDTH = 32;
        private static final int ICON_HEIGHT = 32;
        private static final int ICON_TEX_WIDTH = 64;
        private static final int ICON_TEX_HEIGHT = 64;
        private static final int ICON_OVERLAY_X_PLAY = 0;
        private static final int ICON_OVERLAY_X_ADD = 32;
        private static final int ICON_OVERLAY_Y_UNSELECTED = 0;
        private static final int ICON_OVERLAY_Y_SELECTED = 32;
        private final PublicServersScreen screen;
        private final class_310 minecraft;
        private final class_642 serverData;
        private final class_2960 iconLocation;
        private byte[] lastIconBytes;
        private class_1043 icon;
        protected long lastClickTime;

        protected ServerEntry(PublicServersScreen screen, class_642 data) {
            this.screen = screen;
            this.serverData = data;
            this.minecraft = class_310.method_1551();
            this.iconLocation = new class_2960("servers/" + Hashing.sha1().hashUnencodedChars((CharSequence)data.field_3761) + "/icon");
            class_1044 abstracttexture = this.minecraft.method_1531().method_34590(this.iconLocation, (class_1044)class_1047.method_4540());
            if (abstracttexture != class_1047.method_4540() && abstracttexture instanceof class_1043) {
                this.icon = (class_1043)abstracttexture;
            }
        }

        public void method_25343(class_4587 matrix, int index, int top, int left, int width, int innerHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            List playerList;
            class_2561 pingTooltip;
            int signal;
            int mouseOverX = mouseX - left;
            int mouseOverY = mouseY - top;
            boolean invalidVersion = this.serverData.field_3756 != class_155.method_16673().method_48020();
            this.minecraft.field_1772.method_1729(matrix, this.serverData.field_3752, (float)(left + 32 + 3), (float)(top + 1), 0xFFFFFF);
            List list = this.minecraft.field_1772.method_1728((class_5348)this.serverData.field_3757, width - 32 - 2);
            for (int i = 0; i < Math.min(list.size(), 2); ++i) {
                this.minecraft.field_1772.method_27528(matrix, (class_5481)list.get(i), (float)(left + 32 + 3), (float)(top + 12 + 9 * i), 0x808080);
            }
            class_2561 invalidVersionErrorText = invalidVersion ? this.serverData.field_3760.method_27661().method_27692(class_124.field_1061) : this.serverData.field_3753;
            int textWidth = this.minecraft.field_1772.method_27525((class_5348)invalidVersionErrorText);
            this.minecraft.field_1772.method_30883(matrix, invalidVersionErrorText, (float)(left + width - textWidth - 15 - 2), (float)(top + 1), 0x808080);
            int signalTexOffset = 0;
            if (invalidVersion) {
                signal = 5;
                pingTooltip = INCOMPATIBLE_TOOLTIP;
                playerList = this.serverData.field_3762;
            } else if (this.serverData.field_3754 && this.serverData.field_3758 != -2L) {
                signal = this.serverData.field_3758 < 0L ? 5 : (this.serverData.field_3758 < 150L ? 0 : (this.serverData.field_3758 < 300L ? 1 : (this.serverData.field_3758 < 600L ? 2 : (this.serverData.field_3758 < 1000L ? 3 : 4))));
                if (this.serverData.field_3758 < 0L) {
                    pingTooltip = NO_CONNECTION_TOOLTIP;
                    playerList = Collections.emptyList();
                } else {
                    pingTooltip = class_2561.method_43469((String)"multiplayer.status.ping", (Object[])new Object[]{this.serverData.field_3758});
                    playerList = this.serverData.field_3762;
                }
            } else {
                signalTexOffset = 1;
                signal = (int)(class_156.method_658() / 100L + (long)(index * 2) & 7L);
                if (signal > 4) {
                    signal = 8 - signal;
                }
                pingTooltip = PINGING_TOOLTIP;
                playerList = Collections.emptyList();
            }
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)class_332.field_22737);
            class_332.method_25290((class_4587)matrix, (int)(left + width - 15), (int)top, (float)(signalTexOffset * 10), (float)(176 + signal * 8), (int)10, (int)8, (int)256, (int)256);
            byte[] iconBytes = this.serverData.method_49306();
            if (!Arrays.equals(iconBytes, this.lastIconBytes)) {
                if (this.uploadServerIcon(iconBytes)) {
                    this.lastIconBytes = iconBytes;
                } else {
                    this.serverData.method_49305(null);
                }
            }
            if (this.icon == null) {
                this.drawIcon(matrix, left, top, ICON_MISSING);
            } else {
                this.drawIcon(matrix, left, top, this.iconLocation);
            }
            if (mouseOverX >= width - 15 && mouseOverX <= width - 5 && mouseOverY >= 0 && mouseOverY <= 8) {
                this.screen.setRenderedTooltip(Collections.singletonList(pingTooltip));
            } else if (mouseOverX >= width - textWidth - 15 - 2 && mouseOverX <= width - 15 - 2 && mouseOverY >= 0 && mouseOverY <= 8) {
                this.screen.setRenderedTooltip(playerList);
            }
            if (((Boolean)this.minecraft.field_1690.method_42446().method_41753()).booleanValue() || hovered) {
                RenderSystem.setShaderTexture((int)0, (class_2960)ICON_OVERLAY_LOCATION);
                class_332.method_25294((class_4587)matrix, (int)left, (int)top, (int)(left + 32), (int)(top + 32), (int)-1601138544);
                RenderSystem.setShader(class_757::method_34542);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (this.canJoin()) {
                    if (mouseOverX > 16 && mouseOverX < 32) {
                        class_332.method_25290((class_4587)matrix, (int)left, (int)top, (float)0.0f, (float)32.0f, (int)32, (int)32, (int)64, (int)64);
                    } else {
                        class_332.method_25290((class_4587)matrix, (int)left, (int)top, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)64, (int)64);
                    }
                }
                if (mouseOverX < 16) {
                    class_332.method_25290((class_4587)matrix, (int)left, (int)top, (float)32.0f, (float)32.0f, (int)32, (int)32, (int)64, (int)64);
                } else {
                    class_332.method_25290((class_4587)matrix, (int)left, (int)top, (float)32.0f, (float)0.0f, (int)32, (int)32, (int)64, (int)64);
                }
            }
        }

        protected void drawIcon(class_4587 p_99890_, int p_99891_, int p_99892_, class_2960 p_99893_) {
            RenderSystem.setShaderTexture((int)0, (class_2960)p_99893_);
            RenderSystem.enableBlend();
            class_332.method_25290((class_4587)p_99890_, (int)p_99891_, (int)p_99892_, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            RenderSystem.disableBlend();
        }

        protected boolean canJoin() {
            return true;
        }

        private boolean uploadServerIcon(byte[] rawImageData) {
            if (rawImageData == null) {
                this.minecraft.method_1531().method_4615(this.iconLocation);
                if (this.icon != null && this.icon.method_4525() != null) {
                    this.icon.method_4525().close();
                }
                this.icon = null;
            } else {
                try {
                    class_1011 nativeimage = class_1011.method_49277((byte[])rawImageData);
                    Validate.validState((nativeimage.method_4307() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                    Validate.validState((nativeimage.method_4323() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                    if (this.icon == null) {
                        this.icon = new class_1043(nativeimage);
                    } else {
                        this.icon.method_4526(nativeimage);
                        this.icon.method_4524();
                    }
                    this.minecraft.method_1531().method_4616(this.iconLocation, (class_1044)this.icon);
                }
                catch (Throwable throwable) {
                    LOGGER.error("Invalid icon for server {} ({})", new Object[]{this.serverData.field_3752, this.serverData.field_3761, throwable});
                    return false;
                }
            }
            return true;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            int serverIndex = PublicServerSelectionList.this.method_25396().indexOf((Object)this);
            double mouseOverX = mouseX - (double)PublicServerSelectionList.this.method_25342();
            if (mouseOverX <= 32.0) {
                if (mouseOverX > 16.0 && this.canJoin()) {
                    this.screen.setSelected(this);
                    this.screen.joinSelectedServer();
                    return true;
                }
                if (mouseOverX < 16.0) {
                    this.screen.setSelected(this);
                    this.screen.addSelectedServer();
                }
            }
            this.screen.setSelected(this);
            if (class_156.method_658() - this.lastClickTime < 250L) {
                this.screen.joinSelectedServer();
                return true;
            }
            this.lastClickTime = class_156.method_658();
            return false;
        }

        public class_642 getServerInfo() {
            return this.serverData;
        }

        public class_2561 method_37006() {
            return class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{this.serverData.field_3752});
        }
    }
}

