/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.servercreatorbanner;

import com.bisecthosting.mods.bhmenu.config.GlobalConfigs;
import com.bisecthosting.mods.bhmenu.config.components.text.TextConfigEditBox;
import com.bisecthosting.mods.bhmenu.config.components.toggle.BooleanConfigButton;
import com.bisecthosting.mods.bhmenu.config.lists.ModuleConfigList;
import com.bisecthosting.mods.bhmenu.config.values.BooleanHolder;
import com.bisecthosting.mods.bhmenu.config.values.StringHolder;
import com.bisecthosting.mods.bhmenu.modules.BaseModule;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerCreatorBanner
extends BaseModule {
    public static final Logger LOGGER = LogManager.getLogger();
    public ForgeConfigSpec.ConfigValue<String> title;
    public ForgeConfigSpec.ConfigValue<String> description;
    public ForgeConfigSpec.BooleanValue useLanguageFiles;

    public ServerCreatorBanner() {
        super("server_creator_banner");
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void replaceMultiplayerScreen(GuiScreenEvent.InitGuiEvent.Pre event) {
        if (!this.isEnabled() || event.getGui().getClass() == JoinMultiplayerScreen.class) {
            // empty if block
        }
    }

    @Override
    public void buildConfigs(ForgeConfigSpec.Builder builder) {
        builder.comment("Modpack Configs").push("pack");
        this.title = builder.comment("The title to display at the top of the entry.").define("title", (Object)"Need a server?");
        this.description = builder.comment("The description to display below the title.").define("description", (Object)"Click me to get your own server!");
        this.useLanguageFiles = builder.comment(new String[]{"Set this to true to use specific language translation keys.", "This requires a custom mod that adds resource files, such as OpenLoader.", "Use 'server_entry.title' key for the Title;", "Use 'server_entry.description' key for the Description."}).define("use_language_files", false);
        builder.pop().comment("User Configs").push("user");
        builder.pop();
    }

    @Override
    public boolean hasPackConfigs() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void populatePackConfigs(ModuleConfigList configs, Consumer<ModuleConfigList.Entry> entries) {
        TranslatableComponent text = new TranslatableComponent("modules.server_creator_banner.config.title");
        ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)GlobalConfigs.getSpec().getRaw(this.title.getPath());
        entries.accept(new ModuleConfigList.Entry(configs, valueSpec.getComment(), (Component)text, (AbstractWidget)new TextConfigEditBox(new StringHolder(this.title), Minecraft.m_91087_().f_91062_, 0, 0, 0, 20, (Component)text)));
        text = new TranslatableComponent("modules.server_creator_banner.config.description");
        valueSpec = (ForgeConfigSpec.ValueSpec)GlobalConfigs.getSpec().getRaw(this.description.getPath());
        entries.accept(new ModuleConfigList.Entry(configs, valueSpec.getComment(), (Component)text, (AbstractWidget)new TextConfigEditBox(new StringHolder(this.description), Minecraft.m_91087_().f_91062_, 0, 0, 0, 20, (Component)text)));
        text = new TranslatableComponent("modules.server_creator_banner.config.use_language_files");
        valueSpec = (ForgeConfigSpec.ValueSpec)GlobalConfigs.getSpec().getRaw(this.useLanguageFiles.getPath());
        entries.accept(new ModuleConfigList.Entry(configs, valueSpec.getComment(), (Component)text, (AbstractWidget)new BooleanConfigButton(new BooleanHolder(this.useLanguageFiles), 0, 0, 0, 20)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void populateUserConfigs(ModuleConfigList configs, Consumer<ModuleConfigList.Entry> entries) {
    }

    public Component getTitle() {
        return (Boolean)this.useLanguageFiles.get() != false ? new TranslatableComponent("server_entry.title") : new TextComponent((String)this.title.get());
    }

    public Component getDescription() {
        return (Boolean)this.useLanguageFiles.get() != false ? new TranslatableComponent("server_entry.description") : new TextComponent((String)this.description.get());
    }
}

