/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.config;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.config.lists.ModuleConfigList;
import com.bisecthosting.mods.bhmenu.modules.IModule;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ModuleConfigScreen
extends Screen {
    private static final String SAVE_TEXT = I18n.func_135052_a((String)"screen.config.save", (Object[])new Object[0]);
    private static final String DISCARD_TEXT = I18n.func_135052_a((String)"screen.config.discard", (Object[])new Object[0]);
    private Screen parent;
    private IModule module;
    private ModuleConfigList configList;
    private final BiConsumer<ModuleConfigList, Consumer<ModuleConfigList.Entry>> configPopulator;

    public ModuleConfigScreen(Screen parent, IModule module, BiConsumer<ModuleConfigList, Consumer<ModuleConfigList.Entry>> configPopulator) {
        super((ITextComponent)new TranslationTextComponent("screen.config.modules." + module.getId() + ".name", new Object[0]));
        this.parent = parent;
        this.module = module;
        this.configPopulator = configPopulator;
    }

    protected void init() {
        super.init();
        if (this.configList == null) {
            this.configList = new ModuleConfigList(this, this.minecraft, this.width, this.height, 40, this.height - 40, 30);
            this.configList.populateModuleConfigList(this.configPopulator);
        }
        this.configList.updateSize(this.width, this.height, 40, this.height - 40);
        this.children.add(this.configList);
        this.addButton((Widget)new Button(this.width / 2 - 105, this.height - 30, 100, 20, SAVE_TEXT, this::saveAndExit));
        this.addButton((Widget)new Button(this.width / 2 + 5, this.height - 30, 100, 20, DISCARD_TEXT, this::discardAndExit));
    }

    public void render(int mouseX, int mouseY, float delta) {
        this.renderBackground();
        this.configList.render(mouseX, mouseY, delta);
        super.render(mouseX, mouseY, delta);
        this.drawCenteredString(this.font, I18n.func_135052_a((String)("screen.config.modules." + this.module.getId() + ".name"), (Object[])new Object[0]), this.width / 2, 10, -1);
    }

    private void saveAndExit(Button button) {
        ModRef.LOGGER.info("Saving config changes");
        this.configList.saveAll();
        this.onClose();
    }

    private void discardAndExit(Button button) {
        ModRef.LOGGER.info("Discarding config changes");
        this.onClose();
    }

    public void onClose() {
        this.minecraft.func_147108_a(this.parent);
    }
}

